/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.dialog.grammar.headers.io;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.io.Charset;
import de.duehl.basics.io.FileHelper;
import de.duehl.basics.text.Text;
import de.duehl.swing.ui.GuiTools;
import de.duehl.vocabulary.japanese.common.persistence.GrammarTableHeaderPersistenceHelper;
import de.duehl.vocabulary.japanese.ui.dialog.grammar.headers.data.GrammarFormAndStringSelection;
import de.duehl.vocabulary.japanese.ui.dialog.grammar.headers.tools.GrammarTableHeaderFieldsToMapCreator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GrammarTableOwnHeadersSaver {
    private final String filename;
    private final List<GrammarFormAndStringSelection> verbGrammarFormAndStringSelections;
    private final List<GrammarFormAndStringSelection> iAdjectiveGrammarFormAndStringSelections;
    private final List<GrammarFormAndStringSelection> naAdjectiveGrammarFormAndStringSelections;
    private boolean success;
    private List<String> problems;

    public GrammarTableOwnHeadersSaver(String string, List<GrammarFormAndStringSelection> list, List<GrammarFormAndStringSelection> list2, List<GrammarFormAndStringSelection> list3) {
        this.filename = string;
        this.verbGrammarFormAndStringSelections = list;
        this.iAdjectiveGrammarFormAndStringSelections = list2;
        this.naAdjectiveGrammarFormAndStringSelections = list3;
    }

    public void save() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        HashMap<String, String> hashMap3 = new HashMap<String, String>();
        this.success = true;
        this.problems = new ArrayList<String>();
        this.storeHeadersFromSelectionsIntoMap(this.verbGrammarFormAndStringSelections, hashMap);
        this.storeHeadersFromSelectionsIntoMap(this.iAdjectiveGrammarFormAndStringSelections, hashMap2);
        this.storeHeadersFromSelectionsIntoMap(this.naAdjectiveGrammarFormAndStringSelections, hashMap3);
        if (this.success) {
            String string = GrammarTableHeaderPersistenceHelper.createGrammarTableHeaderPesistenceString(hashMap);
            String string2 = GrammarTableHeaderPersistenceHelper.createGrammarTableHeaderPesistenceString(hashMap2);
            String string3 = GrammarTableHeaderPersistenceHelper.createGrammarTableHeaderPesistenceString(hashMap3);
            List<String> list = CollectionsHelper.buildListFrom(string, string2, string3);
            FileHelper.writeLinesToFile(list, this.filename, Charset.UTF_8);
        } else {
            GuiTools.informUser("Die \u00dcberschriften k\u00f6nnen nicht gespeichert werden", Text.join("\n\n", this.problems));
        }
    }

    private void storeHeadersFromSelectionsIntoMap(List<GrammarFormAndStringSelection> list, Map<String, String> map) {
        GrammarTableHeaderFieldsToMapCreator grammarTableHeaderFieldsToMapCreator = new GrammarTableHeaderFieldsToMapCreator(list, map);
        grammarTableHeaderFieldsToMapCreator.create();
        if (!grammarTableHeaderFieldsToMapCreator.isSuccess()) {
            this.success = false;
            this.problems.addAll(grammarTableHeaderFieldsToMapCreator.getProblems());
        }
    }
}

