/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.dialog.kana.hiraganatest;

import de.duehl.basics.text.NumberString;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.components.selections.SelectionsHelper;
import de.duehl.swing.ui.components.selections.StringSelection;
import de.duehl.swing.ui.dialogs.base.ModalDialogBase;
import de.duehl.swing.ui.layout.VerticalLayout;
import de.duehl.vocabulary.japanese.common.data.InternalAdditionalKanaData;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.data.FumikoDataStructures;
import de.duehl.vocabulary.japanese.data.symbol.Hiragana;
import de.duehl.vocabulary.japanese.logic.symbol.kana.internal.InternalKanaDataRequester;
import de.duehl.vocabulary.japanese.logic.symbol.kana.test.HiraganaTestChecker;
import de.duehl.vocabulary.japanese.logic.symbol.kana.test.data.SingleUserInputHiraganaCheckResult;
import de.duehl.vocabulary.japanese.ui.data.FumikoUiObjects;
import de.duehl.vocabulary.japanese.ui.dialog.kana.hiraganatest.AllHiraganaTestEvaluationDialog;
import de.duehl.vocabulary.japanese.ui.dialog.kana.hiraganatest.HiraganaTestEvaluationDialog;
import de.duehl.vocabulary.japanese.ui.dialog.kana.hiraganatest.components.HiraganaLabel;
import de.duehl.vocabulary.japanese.ui.tools.VocabularyTrainerUiTools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class HiraganaTester
extends ModalDialogBase {
    private static final Dimension DIALOG_DIMENSION = new Dimension(900, 800);
    private final List<Hiragana> hiraganaToTest;
    private final FumikoDataStructures dataStructures;
    private final HiraganaLabel hiraganaLabel;
    private final StringSelection hepburnTextField;
    private int shownHiraganaIndex;
    private int tested;
    private int correctTested;
    private final JButton quitButton;
    private final double lastTenTestsPercentBefore;
    private final StringSelection numberOfHiraganaSelection;
    private final StringSelection numberOfDoneHiraganaSelection;
    private final StringSelection numberOfCorrectDoneHiraganaSelection;
    private final StringSelection correctDonePercentHiraganaSelection;

    public HiraganaTester(List<Hiragana> list, FumikoDataStructures fumikoDataStructures, FumikoUiObjects fumikoUiObjects) {
        super(fumikoUiObjects.getGuiLocation(), fumikoUiObjects.getProgramImage(), "Hiragana-Test", DIALOG_DIMENSION);
        this.hiraganaToTest = list;
        this.dataStructures = fumikoDataStructures;
        this.hiraganaLabel = new HiraganaLabel();
        this.hepburnTextField = new StringSelection("Hepburn-Darstellung");
        this.quitButton = new JButton("");
        this.lastTenTestsPercentBefore = VocabularyTrainerUiTools.createLastTenHiraganaTestsPercent(list, fumikoDataStructures);
        this.numberOfHiraganaSelection = new StringSelection("Anzahl abzufragender Hiragana");
        this.numberOfDoneHiraganaSelection = new StringSelection("Anzahl bereits abgefragte Hiragana");
        this.numberOfCorrectDoneHiraganaSelection = new StringSelection("Anzahl korrekt beantworteter Hiragana");
        this.correctDonePercentHiraganaSelection = new StringSelection("Prozent korrekt beantworteter Hiragana");
        this.init();
        this.fillDialog();
    }

    private void init() {
        this.tested = 0;
        this.correctTested = 0;
        this.initStringSelections();
        this.shownHiraganaIndex = 0;
        this.showHiraganaAtIndex();
    }

    private void initStringSelections() {
        SelectionsHelper.initSelectionAsEditor(this.hepburnTextField);
        this.hepburnTextField.addReturnListener(() -> this.checkAndShowNextOrEndDialog());
        SelectionsHelper.initSelectionAsViewer(this.numberOfHiraganaSelection);
        SelectionsHelper.initSelectionAsViewer(this.numberOfDoneHiraganaSelection);
        SelectionsHelper.initSelectionAsViewer(this.numberOfCorrectDoneHiraganaSelection);
        SelectionsHelper.initSelectionAsViewer(this.correctDonePercentHiraganaSelection);
        this.numberOfHiraganaSelection.setText(NumberString.taupu(this.hiraganaToTest.size()));
        this.setNumbersAndPercent();
    }

    private void showHiraganaAtIndex() {
        Hiragana hiragana = this.hiraganaToTest.get(this.shownHiraganaIndex);
        this.hiraganaLabel.showHiragana(hiragana);
        this.hepburnTextField.setText("");
        this.hepburnTextField.requestFocus();
    }

    @Override
    protected void populateDialog() {
        this.add(this.createCenterPart(), "Center");
    }

    private Component createCenterPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createSummeryPart(), "North");
        jPanel.add(this.createHiraganaLablePart(), "Center");
        jPanel.add(this.createUserInputPart(), "South");
        return jPanel;
    }

    private Component createSummeryPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 0, 3, 3));
        jPanel.add(this.numberOfHiraganaSelection.getPanel());
        jPanel.add(this.numberOfDoneHiraganaSelection.getPanel());
        jPanel.add(this.numberOfCorrectDoneHiraganaSelection.getPanel());
        jPanel.add(this.correctDonePercentHiraganaSelection.getPanel());
        return jPanel;
    }

    private Component createHiraganaLablePart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        GuiTools.createTitle(jPanel);
        jPanel.add((Component)this.hiraganaLabel.getLabel(), "Center");
        return jPanel;
    }

    private Component createUserInputPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createPureUserInputPart(), "Center");
        jPanel.add(this.createButtonsPart(), "South");
        return jPanel;
    }

    private Component createPureUserInputPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(3, 3));
        GuiTools.createTitle(jPanel);
        jPanel.add(this.hepburnTextField.getPanel());
        return jPanel;
    }

    private Component createButtonsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createQuitButton(), "West");
        jPanel.add(this.createOkButton(), "East");
        return jPanel;
    }

    private Component createQuitButton() {
        this.quitButton.setText("Abbrechen");
        this.quitButton.addActionListener(actionEvent -> this.quit());
        return this.quitButton;
    }

    private void quit() {
        this.closeDialog();
    }

    private Component createOkButton() {
        JButton jButton = new JButton("   Pr\u00fcfen   ");
        GuiTools.biggerFont(jButton, 5);
        jButton.addActionListener(actionEvent -> this.checkAndShowNextOrEndDialog());
        return jButton;
    }

    private void checkAndShowNextOrEndDialog() {
        ++this.tested;
        SingleUserInputHiraganaCheckResult singleUserInputHiraganaCheckResult = this.check();
        boolean bl = singleUserInputHiraganaCheckResult.isOk();
        if (singleUserInputHiraganaCheckResult.isOk()) {
            ++this.correctTested;
        }
        boolean bl2 = this.showSingleUserInputCheckResult(singleUserInputHiraganaCheckResult);
        if (!singleUserInputHiraganaCheckResult.isOk() && bl2) {
            ++this.correctTested;
            bl = true;
        }
        this.saveUserTestAnswerInInternalHiraganaData(singleUserInputHiraganaCheckResult.getHiragana(), bl);
        this.setNumbersAndPercent();
        if (this.tested == this.hiraganaToTest.size()) {
            this.closeDialog();
            this.showTotalUserInputCheckResult();
        } else {
            ++this.shownHiraganaIndex;
            this.showHiraganaAtIndex();
        }
    }

    private SingleUserInputHiraganaCheckResult check() {
        Hiragana hiragana = this.hiraganaToTest.get(this.shownHiraganaIndex);
        String string = this.hepburnTextField.getTrimmedText();
        HiraganaTestChecker hiraganaTestChecker = new HiraganaTestChecker(hiragana, string);
        hiraganaTestChecker.check();
        return hiraganaTestChecker.getResult();
    }

    private boolean showSingleUserInputCheckResult(SingleUserInputHiraganaCheckResult singleUserInputHiraganaCheckResult) {
        String string = this.hepburnTextField.getTrimmedText();
        Options options = this.dataStructures.getOptions();
        HiraganaTestEvaluationDialog hiraganaTestEvaluationDialog = new HiraganaTestEvaluationDialog(singleUserInputHiraganaCheckResult, string, options, this.getParentLocation(), this.getProgramImage());
        hiraganaTestEvaluationDialog.setVisible(true);
        if (singleUserInputHiraganaCheckResult.isOk()) {
            return false;
        }
        return hiraganaTestEvaluationDialog.wasOnlyTypingError();
    }

    private void saveUserTestAnswerInInternalHiraganaData(Hiragana hiragana, boolean bl) {
        InternalKanaDataRequester internalKanaDataRequester = this.dataStructures.getInternalKanaDataRequester();
        InternalAdditionalKanaData internalAdditionalKanaData = internalKanaDataRequester.getInternalDataForHiragana(hiragana);
        internalAdditionalKanaData.tested(bl);
    }

    public void setNumbersAndPercent() {
        this.numberOfDoneHiraganaSelection.setText(NumberString.taupu(this.tested));
        this.numberOfCorrectDoneHiraganaSelection.setText(NumberString.taupu(this.correctTested));
        if (this.tested == 0) {
            this.correctDonePercentHiraganaSelection.setText("0.00 %");
        } else {
            this.correctDonePercentHiraganaSelection.setText(NumberString.percent(this.correctTested, this.tested) + " %");
        }
    }

    private void showTotalUserInputCheckResult() {
        this.quitButton.setText("Beenden");
        SwingUtilities.invokeLater(() -> this.quitButton.requestFocus());
        double d = VocabularyTrainerUiTools.createLastTenHiraganaTestsPercent(this.hiraganaToTest, this.dataStructures);
        String string = this.createDialogTitle("Hiragana abfragen");
        Options options = this.dataStructures.getOptions();
        AllHiraganaTestEvaluationDialog allHiraganaTestEvaluationDialog = new AllHiraganaTestEvaluationDialog(options, this.tested, this.correctTested, this.getLocation(), this.getProgramImage(), this.lastTenTestsPercentBefore, d, string);
        allHiraganaTestEvaluationDialog.setVisible(true);
    }

    private String createDialogTitle(String string) {
        return VocabularyTrainerUiTools.generateTitleWithHiraganaTestSuccesss(this.hiraganaToTest, string, this.dataStructures);
    }
}

