/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.dialog.kana.hiraganatest.components;

import de.duehl.swing.ui.components.selections.SelectionsHelper;
import de.duehl.swing.ui.components.selections.StringSelection;
import de.duehl.swing.ui.layout.VerticalLayout;
import de.duehl.vocabulary.japanese.common.data.InternalAdditionalKanaData;
import de.duehl.vocabulary.japanese.data.symbol.Hiragana;
import de.duehl.vocabulary.japanese.logic.symbol.kana.internal.InternalKanaDataRequester;
import de.duehl.vocabulary.japanese.ui.dialog.kana.hiraganatest.components.HiraganaLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;

public class HiraganaPanel {
    private final HiraganaLabel hiraganaLabel = new HiraganaLabel();
    private boolean showInternalHiraganaData;
    private boolean showHiraganaAsViewerToo;
    private InternalKanaDataRequester requester;
    private final JPanel panel;
    private final StringSelection hiraganaAsCharacterSeletion;
    private final StringSelection hepburnSelection;
    private final StringSelection subTypeSelection;
    private final StringSelection testCountSelection;
    private final StringSelection correctTestCountSelection;
    private final StringSelection lastTestDatetSelection;
    private final StringSelection lastCorrectTestDateSelection;
    private final StringSelection lastTenTestResultsSelection;

    public HiraganaPanel() {
        this.hiraganaLabel.setBiggerFontSize(200);
        this.showInternalHiraganaData = false;
        this.showHiraganaAsViewerToo = false;
        this.panel = new JPanel();
        this.hiraganaAsCharacterSeletion = new StringSelection("Das Hiragana (noch einmal zum rauskopieren)");
        this.hepburnSelection = new StringSelection("Hepburn-Darstellung");
        this.subTypeSelection = new StringSelection("Unterart");
        this.testCountSelection = new StringSelection("Anzahl Test");
        this.correctTestCountSelection = new StringSelection("Anzahl erfolgreicher Test");
        this.lastTestDatetSelection = new StringSelection("zuletzt getestet am");
        this.lastCorrectTestDateSelection = new StringSelection("zuletzt erfolgreich getestet am");
        this.lastTenTestResultsSelection = new StringSelection("Erfolg der letzten Tests");
        this.init();
    }

    private void init() {
        this.initAssetFocusableViewer(this.hiraganaAsCharacterSeletion);
        this.initAssetFocusableViewer(this.hiraganaAsCharacterSeletion);
        this.initAssetFocusableViewer(this.hepburnSelection);
        this.initAssetFocusableViewer(this.subTypeSelection);
        this.initAssetFocusableViewer(this.testCountSelection);
        this.initAssetFocusableViewer(this.correctTestCountSelection);
        this.initAssetFocusableViewer(this.lastTestDatetSelection);
        this.initAssetFocusableViewer(this.lastCorrectTestDateSelection);
        this.initAssetFocusableViewer(this.lastTenTestResultsSelection);
    }

    private void initAssetFocusableViewer(StringSelection stringSelection) {
        SelectionsHelper.initSelectionAsViewer(stringSelection);
        stringSelection.setFocusable(true);
    }

    public void showHiraganaAsViewerToo() {
        this.showHiraganaAsViewerToo = true;
    }

    public void showInternalHiraganaDataToo(InternalKanaDataRequester internalKanaDataRequester) {
        this.showInternalHiraganaData = true;
        this.requester = internalKanaDataRequester;
    }

    public void createGui() {
        this.panel.setLayout(new BorderLayout());
        this.panel.add((Component)this.hiraganaLabel.getLabel(), "Center");
        this.panel.add(this.createGermanMeaningOnLesungenAndKunLesungenAndPerhapsInternalDataPart(), "South");
    }

    private Component createGermanMeaningOnLesungenAndKunLesungenAndPerhapsInternalDataPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(0, 3));
        if (this.showHiraganaAsViewerToo) {
            jPanel.add(this.hiraganaAsCharacterSeletion.getPanel());
        }
        jPanel.add(this.createHepburnAndSubTypePart());
        if (this.showInternalHiraganaData) {
            jPanel.add(this.createInternalHiraganaDataPart());
        }
        return jPanel;
    }

    private Component createHepburnAndSubTypePart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(0, 3));
        jPanel.add(this.hepburnSelection.getPanel());
        jPanel.add(this.subTypeSelection.getPanel());
        return jPanel;
    }

    private Component createInternalHiraganaDataPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(0, 3));
        jPanel.add(this.testCountSelection.getPanel());
        jPanel.add(this.correctTestCountSelection.getPanel());
        jPanel.add(this.lastTestDatetSelection.getPanel());
        jPanel.add(this.lastCorrectTestDateSelection.getPanel());
        jPanel.add(this.lastTenTestResultsSelection.getPanel());
        return jPanel;
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public void showHiragana(Hiragana hiragana) {
        this.hiraganaLabel.showHiragana(hiragana);
        this.hiraganaAsCharacterSeletion.setText(hiragana.getCharacter());
        this.hepburnSelection.setText(hiragana.getHepburn());
        this.subTypeSelection.setText(hiragana.getSubType().getDescription());
        if (this.showInternalHiraganaData) {
            InternalAdditionalKanaData internalAdditionalKanaData = this.requester.getInternalDataForHiragana(hiragana);
            this.testCountSelection.setText(internalAdditionalKanaData.getTestCount());
            this.correctTestCountSelection.setText(internalAdditionalKanaData.getCorrectTestCount());
            this.lastTestDatetSelection.setText(internalAdditionalKanaData.getLastTestDate().toString());
            this.lastCorrectTestDateSelection.setText(internalAdditionalKanaData.getLastCorrectTestDate().toString());
            this.lastTenTestResultsSelection.setText(internalAdditionalKanaData.getLastTenTestResultsAsStorageString());
        }
    }
}

