/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.dialog.kana.katakanatest;

import de.duehl.basics.text.NumberString;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.components.selections.SelectionsHelper;
import de.duehl.swing.ui.components.selections.StringSelection;
import de.duehl.swing.ui.dialogs.base.ModalDialogBase;
import de.duehl.swing.ui.layout.VerticalLayout;
import de.duehl.vocabulary.japanese.common.data.InternalAdditionalKanaData;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.data.FumikoDataStructures;
import de.duehl.vocabulary.japanese.data.symbol.Katakana;
import de.duehl.vocabulary.japanese.logic.symbol.kana.internal.InternalKanaDataRequester;
import de.duehl.vocabulary.japanese.logic.symbol.kana.test.KatakanaTestChecker;
import de.duehl.vocabulary.japanese.logic.symbol.kana.test.data.SingleUserInputKatakanaCheckResult;
import de.duehl.vocabulary.japanese.ui.data.FumikoUiObjects;
import de.duehl.vocabulary.japanese.ui.dialog.kana.katakanatest.AllKatakanaTestEvaluationDialog;
import de.duehl.vocabulary.japanese.ui.dialog.kana.katakanatest.KatakanaTestEvaluationDialog;
import de.duehl.vocabulary.japanese.ui.dialog.kana.katakanatest.components.KatakanaLabel;
import de.duehl.vocabulary.japanese.ui.tools.VocabularyTrainerUiTools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class KatakanaTester
extends ModalDialogBase {
    private static final Dimension DIALOG_DIMENSION = new Dimension(900, 800);
    private final List<Katakana> katakanaToTest;
    private final FumikoDataStructures dataStructures;
    private final KatakanaLabel katakanaLabel;
    private final StringSelection hepburnTextField;
    private int shownKatakanaIndex;
    private int tested;
    private int correctTested;
    private final JButton quitButton;
    private final double lastTenTestsPercentBefore;
    private final StringSelection numberOfKatakanaSelection;
    private final StringSelection numberOfDoneKatakanaSelection;
    private final StringSelection numberOfCorrectDoneKatakanaSelection;
    private final StringSelection correctDonePercentKatakanaSelection;

    public KatakanaTester(List<Katakana> list, FumikoDataStructures fumikoDataStructures, FumikoUiObjects fumikoUiObjects) {
        super(fumikoUiObjects.getGuiLocation(), fumikoUiObjects.getProgramImage(), "Katakana-Test", DIALOG_DIMENSION);
        this.katakanaToTest = list;
        this.dataStructures = fumikoDataStructures;
        this.katakanaLabel = new KatakanaLabel();
        this.hepburnTextField = new StringSelection("Hepburn-Darstellung");
        this.quitButton = new JButton("");
        this.lastTenTestsPercentBefore = VocabularyTrainerUiTools.createLastTenKatakanaTestsPercent(list, fumikoDataStructures);
        this.numberOfKatakanaSelection = new StringSelection("Anzahl abzufragender Katakana");
        this.numberOfDoneKatakanaSelection = new StringSelection("Anzahl bereits abgefragte Katakana");
        this.numberOfCorrectDoneKatakanaSelection = new StringSelection("Anzahl korrekt beantworteter Katakana");
        this.correctDonePercentKatakanaSelection = new StringSelection("Prozent korrekt beantworteter Katakana");
        this.init();
        this.fillDialog();
    }

    private void init() {
        this.tested = 0;
        this.correctTested = 0;
        this.initStringSelections();
        this.shownKatakanaIndex = 0;
        this.showKatakanaAtIndex();
    }

    private void initStringSelections() {
        SelectionsHelper.initSelectionAsEditor(this.hepburnTextField);
        this.hepburnTextField.addReturnListener(() -> this.checkAndShowNextOrEndDialog());
        SelectionsHelper.initSelectionAsViewer(this.numberOfKatakanaSelection);
        SelectionsHelper.initSelectionAsViewer(this.numberOfDoneKatakanaSelection);
        SelectionsHelper.initSelectionAsViewer(this.numberOfCorrectDoneKatakanaSelection);
        SelectionsHelper.initSelectionAsViewer(this.correctDonePercentKatakanaSelection);
        this.numberOfKatakanaSelection.setText(NumberString.taupu(this.katakanaToTest.size()));
        this.setNumbersAndPercent();
    }

    private void showKatakanaAtIndex() {
        Katakana katakana = this.katakanaToTest.get(this.shownKatakanaIndex);
        this.katakanaLabel.showKatakana(katakana);
        this.hepburnTextField.setText("");
        this.hepburnTextField.requestFocus();
    }

    @Override
    protected void populateDialog() {
        this.add(this.createCenterPart(), "Center");
    }

    private Component createCenterPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createSummeryPart(), "North");
        jPanel.add(this.createKatakanaLablePart(), "Center");
        jPanel.add(this.createUserInputPart(), "South");
        return jPanel;
    }

    private Component createSummeryPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 0, 3, 3));
        jPanel.add(this.numberOfKatakanaSelection.getPanel());
        jPanel.add(this.numberOfDoneKatakanaSelection.getPanel());
        jPanel.add(this.numberOfCorrectDoneKatakanaSelection.getPanel());
        jPanel.add(this.correctDonePercentKatakanaSelection.getPanel());
        return jPanel;
    }

    private Component createKatakanaLablePart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        GuiTools.createTitle(jPanel);
        jPanel.add((Component)this.katakanaLabel.getLabel(), "Center");
        return jPanel;
    }

    private Component createUserInputPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createPureUserInputPart(), "Center");
        jPanel.add(this.createButtonsPart(), "South");
        return jPanel;
    }

    private Component createPureUserInputPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(3, 3));
        GuiTools.createTitle(jPanel);
        jPanel.add(this.hepburnTextField.getPanel());
        return jPanel;
    }

    private Component createButtonsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createQuitButton(), "West");
        jPanel.add(this.createOkButton(), "East");
        return jPanel;
    }

    private Component createQuitButton() {
        this.quitButton.setText("Abbrechen");
        this.quitButton.addActionListener(actionEvent -> this.quit());
        return this.quitButton;
    }

    private void quit() {
        this.closeDialog();
    }

    private Component createOkButton() {
        JButton jButton = new JButton("   Pr\u00fcfen   ");
        GuiTools.biggerFont(jButton, 5);
        jButton.addActionListener(actionEvent -> this.checkAndShowNextOrEndDialog());
        return jButton;
    }

    private void checkAndShowNextOrEndDialog() {
        ++this.tested;
        SingleUserInputKatakanaCheckResult singleUserInputKatakanaCheckResult = this.check();
        boolean bl = singleUserInputKatakanaCheckResult.isOk();
        if (singleUserInputKatakanaCheckResult.isOk()) {
            ++this.correctTested;
        }
        boolean bl2 = this.showSingleUserInputCheckResult(singleUserInputKatakanaCheckResult);
        if (!singleUserInputKatakanaCheckResult.isOk() && bl2) {
            ++this.correctTested;
            bl = true;
        }
        this.saveUserTestAnswerInInternalKatakanaData(singleUserInputKatakanaCheckResult.getKatakana(), bl);
        this.setNumbersAndPercent();
        if (this.tested == this.katakanaToTest.size()) {
            this.closeDialog();
            this.showTotalUserInputCheckResult();
        } else {
            ++this.shownKatakanaIndex;
            this.showKatakanaAtIndex();
        }
    }

    private SingleUserInputKatakanaCheckResult check() {
        Katakana katakana = this.katakanaToTest.get(this.shownKatakanaIndex);
        String string = this.hepburnTextField.getTrimmedText();
        KatakanaTestChecker katakanaTestChecker = new KatakanaTestChecker(katakana, string);
        katakanaTestChecker.check();
        return katakanaTestChecker.getResult();
    }

    private boolean showSingleUserInputCheckResult(SingleUserInputKatakanaCheckResult singleUserInputKatakanaCheckResult) {
        String string = this.hepburnTextField.getTrimmedText();
        Options options = this.dataStructures.getOptions();
        KatakanaTestEvaluationDialog katakanaTestEvaluationDialog = new KatakanaTestEvaluationDialog(singleUserInputKatakanaCheckResult, string, options, this.getParentLocation(), this.getProgramImage());
        katakanaTestEvaluationDialog.setVisible(true);
        if (singleUserInputKatakanaCheckResult.isOk()) {
            return false;
        }
        return katakanaTestEvaluationDialog.wasOnlyTypingError();
    }

    private void saveUserTestAnswerInInternalKatakanaData(Katakana katakana, boolean bl) {
        InternalKanaDataRequester internalKanaDataRequester = this.dataStructures.getInternalKanaDataRequester();
        InternalAdditionalKanaData internalAdditionalKanaData = internalKanaDataRequester.getInternalDataForKatakana(katakana);
        internalAdditionalKanaData.tested(bl);
    }

    public void setNumbersAndPercent() {
        this.numberOfDoneKatakanaSelection.setText(NumberString.taupu(this.tested));
        this.numberOfCorrectDoneKatakanaSelection.setText(NumberString.taupu(this.correctTested));
        if (this.tested == 0) {
            this.correctDonePercentKatakanaSelection.setText("0.00 %");
        } else {
            this.correctDonePercentKatakanaSelection.setText(NumberString.percent(this.correctTested, this.tested) + " %");
        }
    }

    private void showTotalUserInputCheckResult() {
        this.quitButton.setText("Beenden");
        SwingUtilities.invokeLater(() -> this.quitButton.requestFocus());
        double d = VocabularyTrainerUiTools.createLastTenKatakanaTestsPercent(this.katakanaToTest, this.dataStructures);
        String string = this.createDialogTitle("Katakana abfragen");
        Options options = this.dataStructures.getOptions();
        AllKatakanaTestEvaluationDialog allKatakanaTestEvaluationDialog = new AllKatakanaTestEvaluationDialog(options, this.tested, this.correctTested, this.getLocation(), this.getProgramImage(), this.lastTenTestsPercentBefore, d, string);
        allKatakanaTestEvaluationDialog.setVisible(true);
    }

    private String createDialogTitle(String string) {
        return VocabularyTrainerUiTools.generateTitleWithKatakanaTestSuccesss(this.katakanaToTest, string, this.dataStructures);
    }
}

