/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.dialog.kana.katakanatest.components;

import de.duehl.swing.ui.components.selections.SelectionsHelper;
import de.duehl.swing.ui.components.selections.StringSelection;
import de.duehl.swing.ui.layout.VerticalLayout;
import de.duehl.vocabulary.japanese.common.data.InternalAdditionalKanaData;
import de.duehl.vocabulary.japanese.data.symbol.Katakana;
import de.duehl.vocabulary.japanese.logic.symbol.kana.internal.InternalKanaDataRequester;
import de.duehl.vocabulary.japanese.ui.dialog.kana.katakanatest.components.KatakanaLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;

public class KatakanaPanel {
    private final KatakanaLabel katakanaLabel = new KatakanaLabel();
    private boolean showInternalKatakanaData;
    private boolean showKatakanaAsViewerToo;
    private InternalKanaDataRequester requester;
    private final JPanel panel;
    private final StringSelection katakanaAsCharacterSeletion;
    private final StringSelection hepburnSelection;
    private final StringSelection subTypeSelection;
    private final StringSelection testCountSelection;
    private final StringSelection correctTestCountSelection;
    private final StringSelection lastTestDatetSelection;
    private final StringSelection lastCorrectTestDateSelection;
    private final StringSelection lastTenTestResultsSelection;

    public KatakanaPanel() {
        this.katakanaLabel.setBiggerFontSize(200);
        this.showInternalKatakanaData = false;
        this.showKatakanaAsViewerToo = false;
        this.panel = new JPanel();
        this.katakanaAsCharacterSeletion = new StringSelection("Das Katakana (noch einmal zum rauskopieren)");
        this.hepburnSelection = new StringSelection("Hepburn-Darstellung");
        this.subTypeSelection = new StringSelection("Unterart");
        this.testCountSelection = new StringSelection("Anzahl Test");
        this.correctTestCountSelection = new StringSelection("Anzahl erfolgreicher Test");
        this.lastTestDatetSelection = new StringSelection("zuletzt getestet am");
        this.lastCorrectTestDateSelection = new StringSelection("zuletzt erfolgreich getestet am");
        this.lastTenTestResultsSelection = new StringSelection("Erfolg der letzten Tests");
        this.init();
    }

    private void init() {
        this.initAssetFocusableViewer(this.katakanaAsCharacterSeletion);
        this.initAssetFocusableViewer(this.katakanaAsCharacterSeletion);
        this.initAssetFocusableViewer(this.hepburnSelection);
        this.initAssetFocusableViewer(this.subTypeSelection);
        this.initAssetFocusableViewer(this.testCountSelection);
        this.initAssetFocusableViewer(this.correctTestCountSelection);
        this.initAssetFocusableViewer(this.lastTestDatetSelection);
        this.initAssetFocusableViewer(this.lastCorrectTestDateSelection);
        this.initAssetFocusableViewer(this.lastTenTestResultsSelection);
    }

    private void initAssetFocusableViewer(StringSelection stringSelection) {
        SelectionsHelper.initSelectionAsViewer(stringSelection);
        stringSelection.setFocusable(true);
    }

    public void showKatakanaAsViewerToo() {
        this.showKatakanaAsViewerToo = true;
    }

    public void showInternalKatakanaDataToo(InternalKanaDataRequester internalKanaDataRequester) {
        this.showInternalKatakanaData = true;
        this.requester = internalKanaDataRequester;
    }

    public void createGui() {
        this.panel.setLayout(new BorderLayout());
        this.panel.add((Component)this.katakanaLabel.getLabel(), "Center");
        this.panel.add(this.createGermanMeaningOnLesungenAndKunLesungenAndPerhapsInternalDataPart(), "South");
    }

    private Component createGermanMeaningOnLesungenAndKunLesungenAndPerhapsInternalDataPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(0, 3));
        if (this.showKatakanaAsViewerToo) {
            jPanel.add(this.katakanaAsCharacterSeletion.getPanel());
        }
        jPanel.add(this.createHepburnAndSubTypePart());
        if (this.showInternalKatakanaData) {
            jPanel.add(this.createInternalKatakanaDataPart());
        }
        return jPanel;
    }

    private Component createHepburnAndSubTypePart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(0, 3));
        jPanel.add(this.hepburnSelection.getPanel());
        jPanel.add(this.subTypeSelection.getPanel());
        return jPanel;
    }

    private Component createInternalKatakanaDataPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(0, 3));
        jPanel.add(this.testCountSelection.getPanel());
        jPanel.add(this.correctTestCountSelection.getPanel());
        jPanel.add(this.lastTestDatetSelection.getPanel());
        jPanel.add(this.lastCorrectTestDateSelection.getPanel());
        jPanel.add(this.lastTenTestResultsSelection.getPanel());
        return jPanel;
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public void showKatakana(Katakana katakana) {
        this.katakanaLabel.showKatakana(katakana);
        this.katakanaAsCharacterSeletion.setText(katakana.getCharacter());
        this.hepburnSelection.setText(katakana.getHepburn());
        this.subTypeSelection.setText(katakana.getSubType().getDescription());
        if (this.showInternalKatakanaData) {
            InternalAdditionalKanaData internalAdditionalKanaData = this.requester.getInternalDataForKatakana(katakana);
            this.testCountSelection.setText(internalAdditionalKanaData.getTestCount());
            this.correctTestCountSelection.setText(internalAdditionalKanaData.getCorrectTestCount());
            this.lastTestDatetSelection.setText(internalAdditionalKanaData.getLastTestDate().toString());
            this.lastCorrectTestDateSelection.setText(internalAdditionalKanaData.getLastCorrectTestDate().toString());
            this.lastTenTestResultsSelection.setText(internalAdditionalKanaData.getLastTenTestResultsAsStorageString());
        }
    }
}

