/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.dialog.kanji.kanjiset;

import de.duehl.basics.io.FileHelper;
import de.duehl.basics.text.Text;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.dialogs.base.NonModalFrameDialogBase;
import de.duehl.swing.ui.layout.VerticalLayout;
import de.duehl.vocabulary.japanese.data.FumikoDataStructures;
import de.duehl.vocabulary.japanese.data.KanjiSet;
import de.duehl.vocabulary.japanese.logic.VocabularyTrainerLogic;
import de.duehl.vocabulary.japanese.ui.components.bars.KanjiSetBar;
import de.duehl.vocabulary.japanese.ui.data.FumikoUiObjects;
import de.duehl.vocabulary.japanese.ui.dialog.kanji.kanjiset.KanjiSetBarsRefresher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class KanjiSetManagementDialog
extends NonModalFrameDialogBase
implements KanjiSetBarsRefresher {
    private static final int MIN_WIDTH = 500;
    private final VocabularyTrainerLogic logic;
    private final FumikoDataStructures dataStructures;
    private final FumikoUiObjects uiObjects;
    private final List<KanjiSet> kanjiSets;
    private final List<KanjiSetBar> bars;
    private final JPanel barsPanel;
    private final JButton newKanjiSetButton;
    private final JButton okButton;

    public KanjiSetManagementDialog(VocabularyTrainerLogic vocabularyTrainerLogic, FumikoDataStructures fumikoDataStructures, FumikoUiObjects fumikoUiObjects, Point point) {
        super(point, fumikoUiObjects.getProgramImage(), "Verwaltung der Kanji-Mengen");
        this.addClosingWindowListener(() -> this.quit());
        this.addEscapeBehaviour();
        this.logic = vocabularyTrainerLogic;
        this.dataStructures = fumikoDataStructures;
        this.uiObjects = fumikoUiObjects;
        this.kanjiSets = fumikoDataStructures.getKanjiSets();
        this.bars = new ArrayList<KanjiSetBar>();
        this.barsPanel = new JPanel();
        this.newKanjiSetButton = new JButton("Neue Kanji-Menge hinzuf\u00fcgen");
        this.okButton = new JButton();
        this.init();
        this.createAndShowBars();
        this.fillDialog();
    }

    private void init() {
        this.initBarsPanel();
        this.initNewKanjiSetButton();
    }

    private void initBarsPanel() {
        this.barsPanel.setLayout(new VerticalLayout(0, 3));
    }

    private void initNewKanjiSetButton() {
        this.newKanjiSetButton.addActionListener(actionEvent -> this.addNewKanjiList());
    }

    private void addNewKanjiList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (KanjiSet object2 : this.kanjiSets) {
            arrayList.add(object2.getName());
        }
        Object object3 = "Den Namen der neuen Kanji-Menge eingeben";
        String string = "Bitte den Namen der neuen Kanji-Menge eingeben.";
        String string2 = GuiTools.askUserToEnterAStringValue(this.getWindowAsComponent(), (String)object3, string);
        if (string2.isBlank()) {
            return;
        }
        if (arrayList.contains(string2)) {
            object3 = "Der Name ist bereits vergeben";
            String string3 = "Den Name '" + string2 + "' ist bereits vergeben.";
            GuiTools.informUser(this.getWindowAsComponent(), (String)object3, string3);
            return;
        }
        KanjiSet kanjiSet = new KanjiSet(string2);
        this.kanjiSets.add(kanjiSet);
        this.createAndShowBars();
    }

    private void createAndShowBars() {
        this.bars.clear();
        this.barsPanel.removeAll();
        this.sortKanjiSets();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (KanjiSet kanjiSet : this.kanjiSets) {
            arrayList.add(kanjiSet.getName());
        }
        for (KanjiSet kanjiSet : this.kanjiSets) {
            KanjiSetBar kanjiSetBar = new KanjiSetBar(kanjiSet, arrayList, this, this.logic, this.dataStructures, this.uiObjects, () -> this.getLocation());
            this.bars.add(kanjiSetBar);
            this.barsPanel.add(kanjiSetBar.getPanel());
        }
        this.barsPanel.invalidate();
        this.barsPanel.validate();
        this.barsPanel.repaint();
        this.pack();
    }

    private void sortKanjiSets() {
        Collections.sort(this.kanjiSets, new Comparator<KanjiSet>(){

            @Override
            public int compare(KanjiSet kanjiSet, KanjiSet kanjiSet2) {
                String string = kanjiSet.getName();
                String string2 = kanjiSet2.getName();
                return Text.compareStringsBetter(string, string2);
            }
        });
    }

    @Override
    protected void populateDialog() {
        this.add(this.createHeaderPart(), "North");
        this.add(this.barsPanel, "Center");
        this.add(this.createButtonsPart(), "South");
        SwingUtilities.invokeLater(() -> this.okButton.requestFocus());
    }

    private Component createHeaderPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(0, 3));
        jPanel.add(this.createDummyMinWidthLabelPart());
        jPanel.add(this.createUpperButtonPart());
        return jPanel;
    }

    private Component createDummyMinWidthLabelPart() {
        JLabel jLabel = new JLabel("");
        jLabel.setPreferredSize(new Dimension(500, 0));
        return jLabel;
    }

    private Component createUpperButtonPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.newKanjiSetButton, "West");
        return jPanel;
    }

    private Component createButtonsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createQuitButton(), "East");
        return jPanel;
    }

    private Component createQuitButton() {
        this.okButton.setText("Beenden");
        this.okButton.addActionListener(actionEvent -> this.quit());
        return this.okButton;
    }

    private void quit() {
        this.saveKanjiLists();
        this.closeDialog();
    }

    private void saveKanjiLists() {
        this.logic.saveKanjiSets();
    }

    @Override
    public void deleteKanjiSetFromListAndFileFromDisk(KanjiSet kanjiSet) {
        this.kanjiSets.remove(kanjiSet);
        String string = kanjiSet.determineFilename();
        if (FileHelper.isFile(string)) {
            FileHelper.deleteFile(string);
        }
    }

    @Override
    public void refreshKanjiSetBars() {
        this.createAndShowBars();
    }
}

