/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.dialog.kanji.kanjiset.filter;

import de.duehl.basics.text.Text;
import de.duehl.swing.ui.components.selections.SearchWordStringSelection;
import de.duehl.swing.ui.components.selections.SelectionsHelper;
import de.duehl.swing.ui.components.selections.data.SearchWordSelectionInputs;
import de.duehl.vocabulary.japanese.data.symbol.Kanji;
import de.duehl.vocabulary.japanese.logic.sort.KanjiListSorter;
import de.duehl.vocabulary.japanese.tools.VocabularyTools;
import de.duehl.vocabulary.japanese.ui.dialog.kanji.kanjiset.filter.FilteredKanjiReactor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class KanjiFilterPanel {
    private final List<Kanji> kanjiList;
    private final FilteredKanjiReactor filteredKanjiReactor;
    private final JPanel panel;
    private final SearchWordStringSelection germanMeaningFilterStringSelection;
    private final SearchWordStringSelection onLesungFilterStringSelection;
    private final SearchWordStringSelection kunLesungFilterStringSelection;
    private final SearchWordStringSelection searchFilterStringSelection;
    private final JButton searchButton;
    private final JButton resetButton;
    private boolean filteringActive;

    public KanjiFilterPanel(List<Kanji> list, FilteredKanjiReactor filteredKanjiReactor) {
        this.kanjiList = list;
        this.filteredKanjiReactor = filteredKanjiReactor;
        this.panel = new JPanel();
        this.germanMeaningFilterStringSelection = new SearchWordStringSelection("Suche in den deutschen Bedeutungen der Kanji");
        this.onLesungFilterStringSelection = new SearchWordStringSelection("Suche in den On-Lesungen der Kanji");
        this.kunLesungFilterStringSelection = new SearchWordStringSelection("Suche in den kun-Lesungen der Kanji");
        this.searchFilterStringSelection = new SearchWordStringSelection("Suche in beliebigen Daten der Kanji oder nach dem Kanjizeichen");
        this.searchButton = new JButton("filtern");
        this.resetButton = new JButton("Felder leeren");
        this.filteringActive = true;
        this.init();
    }

    private void init() {
        this.initSearchFields();
        this.initButtons();
        this.initPanel();
    }

    private void initSearchFields() {
        this.initSearchWordStringSelection(this.germanMeaningFilterStringSelection);
        this.initSearchWordStringSelection(this.onLesungFilterStringSelection);
        this.initSearchWordStringSelection(this.kunLesungFilterStringSelection);
        this.initSearchWordStringSelection(this.searchFilterStringSelection);
        this.requestFocusInSearchFieldLater();
    }

    private void initSearchWordStringSelection(SearchWordStringSelection searchWordStringSelection) {
        searchWordStringSelection.addReturnListener(() -> this.searchButton.doClick());
        searchWordStringSelection.biggerText(5);
        SelectionsHelper.initSelectionAsEditor(searchWordStringSelection);
        searchWordStringSelection.setCheckboxesFocusable(false);
    }

    private void initButtons() {
        this.searchButton.addActionListener(actionEvent -> this.filterKanjiList());
        this.resetButton.addActionListener(actionEvent -> this.reset());
    }

    private void filterKanjiList() {
        if (this.filteringActive) {
            List<Kanji> list = this.createFilteredKanjiList();
            this.sort(list);
            this.filteredKanjiReactor.reactOnFilteredKanjiList(list);
        }
    }

    public List<Kanji> createFilteredKanjiList() {
        ArrayList<Kanji> arrayList = new ArrayList<Kanji>();
        SearchWordSelectionInputs searchWordSelectionInputs = this.germanMeaningFilterStringSelection.getInputs();
        SearchWordSelectionInputs searchWordSelectionInputs2 = this.onLesungFilterStringSelection.getInputs();
        SearchWordSelectionInputs searchWordSelectionInputs3 = this.kunLesungFilterStringSelection.getInputs();
        SearchWordSelectionInputs searchWordSelectionInputs4 = this.searchFilterStringSelection.getInputs();
        for (Kanji kanji : this.kanjiList) {
            boolean bl;
            String string = kanji.getGermanMeaning();
            List<String> list = kanji.getOnLesungen();
            List<String> list2 = kanji.getKunLesungen();
            String string2 = Text.toLowerCase(string);
            List<String> list3 = Text.toLowerCase(list);
            List<String> list4 = Text.toLowerCase(list2);
            String string3 = kanji.getCharacter();
            boolean bl2 = searchWordSelectionInputs.isTextEmpty() || this.singleWordContains(searchWordSelectionInputs, string, string2);
            boolean bl3 = searchWordSelectionInputs2.isTextEmpty() || this.listWordContains(searchWordSelectionInputs2, list, list3);
            boolean bl4 = searchWordSelectionInputs3.isTextEmpty() || this.listWordContains(searchWordSelectionInputs3, list2, list4);
            boolean bl5 = bl = searchWordSelectionInputs4.isTextEmpty() || this.singleWordContains(searchWordSelectionInputs4, string, string2) || this.listWordContains(searchWordSelectionInputs4, list, list3) || this.listWordContains(searchWordSelectionInputs4, list2, list4) || string3.equals(searchWordSelectionInputs4.getText());
            if (!bl2 || !bl3 || !bl4 || !bl) continue;
            arrayList.add(kanji);
        }
        return arrayList;
    }

    private boolean listWordContains(SearchWordSelectionInputs searchWordSelectionInputs, List<String> list, List<String> list2) {
        if (list.size() != list2.size()) {
            throw new RuntimeException("Die Listen sind unterschiedlich gro\u00df!\n\toriginalValues.size() = " + list.size() + "\n\tcompareValues.size()  = " + list2.size() + "\n");
        }
        for (int i = 0; i < list.size(); ++i) {
            String string;
            String string2 = list.get(i);
            if (!this.singleWordContains(searchWordSelectionInputs, string2, string = list2.get(i))) continue;
            return true;
        }
        return false;
    }

    private boolean singleWordContains(SearchWordSelectionInputs searchWordSelectionInputs, String string, String string2) {
        String string3;
        String string4;
        if (searchWordSelectionInputs.isWholeWordSearch()) {
            if (searchWordSelectionInputs.isCaseSensitiveSearch()) {
                string4 = searchWordSelectionInputs.getText();
                string3 = string;
            } else {
                string4 = Text.toLowerCase(searchWordSelectionInputs.getText());
                string3 = Text.toLowerCase(string);
            }
        } else if (searchWordSelectionInputs.isCaseSensitiveSearch()) {
            string4 = VocabularyTools.removePuncuationMarks(searchWordSelectionInputs.getText());
            string3 = VocabularyTools.removePuncuationMarks(string);
        } else {
            string4 = VocabularyTools.createCompareTranslation(searchWordSelectionInputs.getText());
            string3 = string2;
        }
        if (searchWordSelectionInputs.isWholeWordSearch()) {
            if (string3.contains(string4)) {
                Pattern pattern = Pattern.compile("\\b" + Pattern.quote(string4) + "\\b");
                Matcher matcher = pattern.matcher(string3);
                return matcher.find();
            }
            return false;
        }
        return string3.contains(string4);
    }

    private void sort(List<Kanji> list) {
        String string = this.getRelevantSearchWord();
        if (!string.isBlank()) {
            KanjiListSorter kanjiListSorter = new KanjiListSorter(list, string);
            kanjiListSorter.sort();
        }
    }

    private String getRelevantSearchWord() {
        SearchWordSelectionInputs searchWordSelectionInputs = this.germanMeaningFilterStringSelection.getInputs();
        SearchWordSelectionInputs searchWordSelectionInputs2 = this.onLesungFilterStringSelection.getInputs();
        SearchWordSelectionInputs searchWordSelectionInputs3 = this.kunLesungFilterStringSelection.getInputs();
        SearchWordSelectionInputs searchWordSelectionInputs4 = this.searchFilterStringSelection.getInputs();
        if (!searchWordSelectionInputs.isTextEmpty()) {
            return searchWordSelectionInputs.getText();
        }
        if (!searchWordSelectionInputs2.isTextEmpty()) {
            return searchWordSelectionInputs2.getText();
        }
        if (!searchWordSelectionInputs3.isTextEmpty()) {
            return searchWordSelectionInputs3.getText();
        }
        if (!searchWordSelectionInputs4.isTextEmpty()) {
            return searchWordSelectionInputs4.getText();
        }
        return "";
    }

    private void reset() {
        this.filteringActive = false;
        SearchWordSelectionInputs searchWordSelectionInputs = new SearchWordSelectionInputs();
        this.germanMeaningFilterStringSelection.loadInputs(searchWordSelectionInputs);
        this.onLesungFilterStringSelection.loadInputs(searchWordSelectionInputs);
        this.kunLesungFilterStringSelection.loadInputs(searchWordSelectionInputs);
        this.searchFilterStringSelection.loadInputs(searchWordSelectionInputs);
        this.filteringActive = true;
        this.searchButton.doClick();
        this.requestFocusInSearchFieldLater();
    }

    private void initPanel() {
        this.panel.setLayout(new BorderLayout());
        this.panel.add(this.createSearchFilterSelections(), "Center");
        this.panel.add(this.createButtonPart(), "South");
    }

    private Component createSearchFilterSelections() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 2, 2, 2));
        jPanel.add(this.onLesungFilterStringSelection.getPanel());
        jPanel.add(this.kunLesungFilterStringSelection.getPanel());
        jPanel.add(this.germanMeaningFilterStringSelection.getPanel());
        jPanel.add(this.searchFilterStringSelection.getPanel());
        return jPanel;
    }

    private Component createButtonPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 2, 1, 1));
        jPanel.add(this.resetButton);
        jPanel.add(this.searchButton);
        return jPanel;
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public void requestFocusInSearchFieldLater() {
        SwingUtilities.invokeLater(() -> this.searchFilterStringSelection.requestFocus());
    }
}

