/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.dialog.kanji.kanjitest;

import de.duehl.basics.text.NumberString;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.components.selections.SelectionsHelper;
import de.duehl.swing.ui.components.selections.StringSelection;
import de.duehl.swing.ui.dialogs.base.ModalDialogBase;
import de.duehl.swing.ui.layout.VerticalLayout;
import de.duehl.vocabulary.japanese.common.data.InternalAdditionalKanjiData;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.data.FumikoDataStructures;
import de.duehl.vocabulary.japanese.data.symbol.Kanji;
import de.duehl.vocabulary.japanese.logic.symbol.kanji.internal.InternalKanjiDataRequester;
import de.duehl.vocabulary.japanese.logic.symbol.kanji.test.KanjiTestChecker;
import de.duehl.vocabulary.japanese.logic.symbol.kanji.test.data.SingleUserInputKanjiCheckResult;
import de.duehl.vocabulary.japanese.ui.data.FumikoUiObjects;
import de.duehl.vocabulary.japanese.ui.data.MessageSetter;
import de.duehl.vocabulary.japanese.ui.dialog.kanji.display.BigKanjiDisplay;
import de.duehl.vocabulary.japanese.ui.dialog.kanji.kanjitest.AllKanjiTestEvaluationDialog;
import de.duehl.vocabulary.japanese.ui.dialog.kanji.kanjitest.KanjiTestEvaluationDialog;
import de.duehl.vocabulary.japanese.ui.tools.VocabularyTrainerUiTools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class KanjiTester
extends ModalDialogBase {
    private static final Dimension DIALOG_DIMENSION = new Dimension(900, 800);
    private final List<Kanji> kanjiToTest;
    private final String kanjiToTestDescription;
    private final boolean germanMeaningCaseSensitivity;
    private final boolean onLesungCaseSensitivity;
    private final boolean kunLesungCaseSensitivity;
    private final FumikoDataStructures dataStructures;
    private final FumikoUiObjects uiObjects;
    private final BigKanjiDisplay bigKanjiDisplay;
    private final StringSelection germanMeaningTextField;
    private final StringSelection onLesungTextField;
    private final StringSelection kunLesungTextField;
    private int shownKanjiIndex;
    private int tested;
    private int correctTested;
    private final JButton quitButton;
    private final double lastTenTestsPercentBefore;
    private final StringSelection numberOfKanjiSelection;
    private final StringSelection numberOfDoneKanjiSelection;
    private final StringSelection numberOfCorrectDoneKanjiSelection;
    private final StringSelection correctDonePercentKanjiSelection;

    public KanjiTester(List<Kanji> list, String string, boolean bl, boolean bl2, boolean bl3, FumikoDataStructures fumikoDataStructures, FumikoUiObjects fumikoUiObjects, Point point) {
        super(point, fumikoUiObjects.getProgramImage(), "Kanji-Test - " + string, DIALOG_DIMENSION);
        this.kanjiToTest = list;
        this.kanjiToTestDescription = string;
        this.germanMeaningCaseSensitivity = bl;
        this.onLesungCaseSensitivity = bl2;
        this.kunLesungCaseSensitivity = bl3;
        this.dataStructures = fumikoDataStructures;
        this.uiObjects = fumikoUiObjects;
        this.germanMeaningTextField = new StringSelection("Deutsche Bedeutung");
        this.onLesungTextField = new StringSelection("ON-Lesung");
        this.kunLesungTextField = new StringSelection("kun-Lesung");
        this.bigKanjiDisplay = new BigKanjiDisplay();
        this.bigKanjiDisplay.setAfterFontButtonPressedRunnable(() -> this.germanMeaningTextField.requestFocusLater());
        this.quitButton = new JButton("");
        this.lastTenTestsPercentBefore = VocabularyTrainerUiTools.createLastTenKanjiTestsPercent(list, fumikoDataStructures);
        this.numberOfKanjiSelection = new StringSelection("Anzahl abzufragender Kanji");
        this.numberOfDoneKanjiSelection = new StringSelection("Anzahl bereits abgefragte Kanji");
        this.numberOfCorrectDoneKanjiSelection = new StringSelection("Anzahl korrekt beantworteter Kanji");
        this.correctDonePercentKanjiSelection = new StringSelection("Prozent korrekt beantworteter Kanji");
        this.init();
        this.fillDialog();
    }

    private void init() {
        this.tested = 0;
        this.correctTested = 0;
        this.initStringSelections();
        this.shownKanjiIndex = 0;
        this.showKanjiAtIndex();
    }

    private void initStringSelections() {
        SelectionsHelper.initSelectionAsEditor(this.germanMeaningTextField);
        SelectionsHelper.initSelectionAsEditor(this.onLesungTextField);
        SelectionsHelper.initSelectionAsEditor(this.kunLesungTextField);
        this.germanMeaningTextField.addReturnListener(() -> this.checkAndShowNextOrEndDialog());
        this.onLesungTextField.addReturnListener(() -> this.checkAndShowNextOrEndDialog());
        this.kunLesungTextField.addReturnListener(() -> this.checkAndShowNextOrEndDialog());
        SelectionsHelper.initSelectionAsViewer(this.numberOfKanjiSelection);
        SelectionsHelper.initSelectionAsViewer(this.numberOfDoneKanjiSelection);
        SelectionsHelper.initSelectionAsViewer(this.numberOfCorrectDoneKanjiSelection);
        SelectionsHelper.initSelectionAsViewer(this.correctDonePercentKanjiSelection);
        this.numberOfKanjiSelection.setText(NumberString.taupu(this.kanjiToTest.size()));
        this.setNumbersAndPercent();
    }

    private void showKanjiAtIndex() {
        Kanji kanji = this.kanjiToTest.get(this.shownKanjiIndex);
        this.bigKanjiDisplay.showKanji(kanji);
        this.germanMeaningTextField.setText("");
        this.onLesungTextField.setText("");
        this.kunLesungTextField.setText("");
        this.germanMeaningTextField.requestFocusLater();
    }

    @Override
    protected void populateDialog() {
        this.add(this.createCenterPart(), "Center");
    }

    private Component createCenterPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createSummeryPart(), "North");
        jPanel.add(this.createBigKanjiDisplayPart(), "Center");
        jPanel.add(this.createUserInputPart(), "South");
        return jPanel;
    }

    private Component createSummeryPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 0, 3, 3));
        jPanel.add(this.numberOfKanjiSelection.getPanel());
        jPanel.add(this.numberOfDoneKanjiSelection.getPanel());
        jPanel.add(this.numberOfCorrectDoneKanjiSelection.getPanel());
        jPanel.add(this.correctDonePercentKanjiSelection.getPanel());
        return jPanel;
    }

    private Component createBigKanjiDisplayPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        GuiTools.createTitle(jPanel);
        jPanel.add((Component)this.bigKanjiDisplay.getComponent(), "Center");
        return jPanel;
    }

    private Component createUserInputPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createPureUserInputPart(), "Center");
        jPanel.add(this.createButtonsPart(), "South");
        return jPanel;
    }

    private Component createPureUserInputPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(3, 3));
        GuiTools.createTitle(jPanel);
        jPanel.add(this.germanMeaningTextField.getPanel());
        jPanel.add(this.onLesungTextField.getPanel());
        jPanel.add(this.kunLesungTextField.getPanel());
        return jPanel;
    }

    private Component createButtonsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createQuitButton(), "West");
        jPanel.add(this.createOkButton(), "East");
        return jPanel;
    }

    private Component createQuitButton() {
        this.quitButton.setText("Abbrechen");
        this.quitButton.addActionListener(actionEvent -> this.quit());
        return this.quitButton;
    }

    private void quit() {
        MessageSetter messageSetter = this.uiObjects.getMessageSetter();
        messageSetter.setMessage("Abfage von Kanji abgebrochen: " + this.kanjiToTestDescription);
        this.closeDialog();
    }

    private Component createOkButton() {
        JButton jButton = new JButton("   Pr\u00fcfen   ");
        GuiTools.biggerFont(jButton, 5);
        jButton.addActionListener(actionEvent -> this.checkAndShowNextOrEndDialog());
        return jButton;
    }

    private void checkAndShowNextOrEndDialog() {
        ++this.tested;
        SingleUserInputKanjiCheckResult singleUserInputKanjiCheckResult = this.check();
        boolean bl = singleUserInputKanjiCheckResult.isOk();
        if (singleUserInputKanjiCheckResult.isOk()) {
            ++this.correctTested;
        }
        boolean bl2 = this.showSingleUserInputCheckResult(singleUserInputKanjiCheckResult);
        if (!singleUserInputKanjiCheckResult.isOk() && bl2) {
            ++this.correctTested;
            bl = true;
        }
        this.saveUserTestAnswerInInternalKanjiData(singleUserInputKanjiCheckResult.getKanji(), bl);
        this.setNumbersAndPercent();
        if (this.tested == this.kanjiToTest.size()) {
            this.closeDialog();
            this.showTotalUserInputCheckResult();
        } else {
            ++this.shownKanjiIndex;
            this.showKanjiAtIndex();
        }
    }

    private SingleUserInputKanjiCheckResult check() {
        Kanji kanji = this.kanjiToTest.get(this.shownKanjiIndex);
        String string = this.germanMeaningTextField.getTrimmedText();
        String string2 = this.onLesungTextField.getTrimmedText();
        String string3 = this.kunLesungTextField.getTrimmedText();
        KanjiTestChecker kanjiTestChecker = new KanjiTestChecker(kanji, string, string2, string3, this.germanMeaningCaseSensitivity, this.onLesungCaseSensitivity, this.kunLesungCaseSensitivity);
        kanjiTestChecker.check();
        return kanjiTestChecker.getResult();
    }

    private boolean showSingleUserInputCheckResult(SingleUserInputKanjiCheckResult singleUserInputKanjiCheckResult) {
        String string = this.germanMeaningTextField.getTrimmedText();
        String string2 = this.onLesungTextField.getTrimmedText();
        String string3 = this.kunLesungTextField.getTrimmedText();
        KanjiTestEvaluationDialog kanjiTestEvaluationDialog = new KanjiTestEvaluationDialog(singleUserInputKanjiCheckResult, string, string2, string3, this.dataStructures, this.uiObjects, this.getLocation());
        kanjiTestEvaluationDialog.setVisible(true);
        if (singleUserInputKanjiCheckResult.isOk()) {
            return false;
        }
        return kanjiTestEvaluationDialog.wasOnlyTypingError();
    }

    private void saveUserTestAnswerInInternalKanjiData(Kanji kanji, boolean bl) {
        InternalKanjiDataRequester internalKanjiDataRequester = this.dataStructures.getInternalKanjiDataRequester();
        InternalAdditionalKanjiData internalAdditionalKanjiData = internalKanjiDataRequester.getInternalDataForKanji(kanji);
        internalAdditionalKanjiData.tested(bl);
    }

    public void setNumbersAndPercent() {
        this.numberOfDoneKanjiSelection.setText(NumberString.taupu(this.tested));
        this.numberOfCorrectDoneKanjiSelection.setText(NumberString.taupu(this.correctTested));
        if (this.tested == 0) {
            this.correctDonePercentKanjiSelection.setText("0.00 %");
        } else {
            this.correctDonePercentKanjiSelection.setText(NumberString.percent(this.correctTested, this.tested) + " %");
        }
    }

    private void showTotalUserInputCheckResult() {
        this.quitButton.setText("Beenden");
        SwingUtilities.invokeLater(() -> this.quitButton.requestFocus());
        Options options = this.dataStructures.getOptions();
        double d = VocabularyTrainerUiTools.createLastTenKanjiTestsPercent(this.kanjiToTest, this.dataStructures);
        String string = this.createDialogTitle("Kanji abfragen - " + this.kanjiToTestDescription);
        AllKanjiTestEvaluationDialog allKanjiTestEvaluationDialog = new AllKanjiTestEvaluationDialog(options, this.tested, this.correctTested, this.getLocation(), this.getProgramImage(), this.lastTenTestsPercentBefore, d, string, this.kanjiToTestDescription);
        allKanjiTestEvaluationDialog.setVisible(true);
        MessageSetter messageSetter = this.uiObjects.getMessageSetter();
        messageSetter.setMessage("Es wurden Kanji abgefragt: " + this.kanjiToTestDescription);
    }

    private String createDialogTitle(String string) {
        return VocabularyTrainerUiTools.generateTitleWithKanjiTestSuccesss(this.kanjiToTest, string, this.dataStructures);
    }
}

