/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.dialog.ownlist;

import de.duehl.swing.persistance.SwingSessionManagerHelper;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.components.selections.SelectionsHelper;
import de.duehl.swing.ui.components.selections.StringSelection;
import de.duehl.swing.ui.dialogs.base.ModalDialogBase;
import de.duehl.swing.ui.layout.VerticalLayout;
import de.duehl.swing.ui.move.data.MovingGui;
import de.duehl.swing.ui.pages.DatasetsOnPages;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.common.persistence.data.HistoricalOwnListPersistanceDataList;
import de.duehl.vocabulary.japanese.data.FumikoDataStructures;
import de.duehl.vocabulary.japanese.data.OwnList;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.logic.ownlists.OwnLists;
import de.duehl.vocabulary.japanese.tools.VocabularyTools;
import de.duehl.vocabulary.japanese.ui.components.bars.VocableBar;
import de.duehl.vocabulary.japanese.ui.data.FumikoUiObjects;
import de.duehl.vocabulary.japanese.ui.dialog.options.OptionsDialog;
import de.duehl.vocabulary.japanese.ui.dialog.vocables.detail.VocableWithInternaDialog;
import de.duehl.vocabulary.japanese.ui.filter.VocableFilterPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public class OwnListEditorDialog
extends ModalDialogBase
implements MovingGui<Vocable> {
    private static final Dimension DIALOG_DIMENSION = new Dimension(1750, 900);
    private final FumikoDataStructures dataStructures;
    private final FumikoUiObjects uiObjects;
    private final OwnList ownList;
    private final List<Vocable> vocables;
    private final VocableFilterPanel vocableFilter;
    private final StringSelection nameSelection;
    private final DatasetsOnPages<Vocable> pages;
    private final JPanel vocablesOfListPanel;
    private final JScrollPane vocablesOfListScroll;
    private final Map<Vocable, VocableBar> barByVocable;
    private final JButton toggleMoveButtonsButton;
    private boolean showMoveButtonsOnBars;
    private final List<String> ownListCategories;
    private final List<String> ownListSubCategories;
    private final JComboBox<String> ownListCategoryComboBox;
    private final JComboBox<String> ownListSubCategoryComboBox;
    private boolean applied;

    public OwnListEditorDialog(OwnList ownList, FumikoDataStructures fumikoDataStructures, FumikoUiObjects fumikoUiObjects) {
        super(fumikoUiObjects.getGuiLocation(), fumikoUiObjects.getProgramImage(), OwnListEditorDialog.createTitle(ownList.getName()), OwnListEditorDialog.createDimension(fumikoDataStructures.getOptions()));
        this.addClosingWindowListener(() -> this.quit());
        this.ownList = ownList;
        this.dataStructures = fumikoDataStructures;
        this.uiObjects = fumikoUiObjects;
        this.barByVocable = new HashMap<Vocable, VocableBar>();
        this.vocables = new ArrayList<Vocable>();
        this.vocables.addAll(ownList.getVocables());
        this.nameSelection = new StringSelection("Name der Liste");
        this.nameSelection.setText(ownList.getName());
        this.vocableFilter = new VocableFilterPanel(fumikoDataStructures, list -> this.reactOnFilteredVocables(list));
        this.toggleMoveButtonsButton = new JButton();
        this.showMoveButtonsOnBars = false;
        this.ownListCategories = new ArrayList<String>();
        this.ownListSubCategories = new ArrayList<String>();
        this.ownListCategoryComboBox = new JComboBox();
        this.ownListSubCategoryComboBox = new JComboBox();
        Options options = fumikoDataStructures.getOptions();
        int n = options.getNumberOfDatasetsPerPageOfOwnListEditor();
        int n2 = options.getNumberOfColumnsOfOwnListEditor();
        this.pages = new DatasetsOnPages<Vocable>(this.vocableFilter.createFilteredVocablesList(), vocable -> this.createDatasetUi((Vocable)vocable), n, n2);
        Point point = options.getLocationOfOwnListEditor();
        if (!point.equals(SwingSessionManagerHelper.NOT_INITIALISED_POINT)) {
            this.setLocation(point);
        }
        this.vocablesOfListPanel = new JPanel();
        this.vocablesOfListScroll = GuiTools.createScrollPane(this.vocablesOfListPanel);
        this.applied = false;
        this.init();
        this.filterVocables();
        this.showVocabelsInList();
        this.fillDialog();
    }

    private static String createTitle(String string) {
        return "Bearbeiten der Vokabelliste '" + string + "'";
    }

    private void setTitle() {
        this.setTitle(OwnListEditorDialog.createTitle(this.nameSelection.getTrimmedText()));
    }

    private static Dimension createDimension(Options options) {
        Dimension dimension = options.getSizeOfOwnListEditor();
        if (dimension.equals(SwingSessionManagerHelper.NOT_INITIALISED_DIMENSION)) {
            return DIALOG_DIMENSION;
        }
        return dimension;
    }

    private Component createDatasetUi(Vocable vocable) {
        VocableBar vocableBar = new VocableBar(vocable, () -> this.addVocable(vocable), this);
        vocableBar.useButtonAsAddVocableToList();
        if (this.vocables.contains(vocable)) {
            vocableBar.disable();
        }
        vocableBar.showExtraDetailButtonOnTheLeft(() -> this.showDetails(vocable));
        vocableBar.createGui();
        this.barByVocable.put(vocable, vocableBar);
        return vocableBar.getPanel();
    }

    private void showDetails(Vocable vocable) {
        VocableWithInternaDialog vocableWithInternaDialog = new VocableWithInternaDialog(vocable, this.dataStructures, this.uiObjects, this.getLocation());
        vocableWithInternaDialog.setVisible(true);
    }

    private void addVocable(Vocable vocable) {
        if (!this.vocables.contains(vocable)) {
            this.addNotContainedVocable(vocable);
        }
    }

    private void addNotContainedVocable(Vocable vocable) {
        this.vocables.add(vocable);
        this.showVocabelsInList();
        VocableBar vocableBar = this.barByVocable.get(vocable);
        vocableBar.disable();
        this.vocableFilter.requestFocusInSearchFieldLater();
        Options options = this.dataStructures.getOptions();
        if (options.isHideVocablesFromListInSearchAreaInOwnListEditor()) {
            int n = this.pages.getActualPageNumber();
            this.filterVocables();
            this.pages.showPage(n);
        }
    }

    private void init() {
        this.initVocableFilter();
        this.initOwnListCategories();
        this.initOwnListSubCategories();
        this.initComboBoxes();
        this.fillComboBoxes();
        this.initVocablesOfListPanel();
        this.initNameSelection();
        this.initToggleButton();
        this.setRightShowAndHideButtonTexts();
        this.setTitle();
    }

    private void initVocableFilter() {
        this.vocableFilter.arrangeForListEditDialog();
    }

    private void initOwnListCategories() {
        OwnLists ownLists = this.dataStructures.getOwnLists();
        this.ownListCategories.addAll(VocabularyTools.determineCategories(ownLists.getOwnLists()));
    }

    private void initOwnListSubCategories() {
        OwnLists ownLists = this.dataStructures.getOwnLists();
        for (OwnList ownList : ownLists.getOwnLists()) {
            String string = ownList.getSubCategory();
            if (this.ownListSubCategories.contains(string)) continue;
            this.ownListSubCategories.add(string);
        }
        Collections.sort(this.ownListSubCategories);
    }

    private void initComboBoxes() {
        this.ownListCategoryComboBox.setAlignmentX(0.0f);
        this.ownListCategoryComboBox.setAlignmentY(0.0f);
        ((JLabel)((Object)this.ownListCategoryComboBox.getRenderer())).setHorizontalAlignment(0);
        this.ownListSubCategoryComboBox.setAlignmentX(0.0f);
        this.ownListSubCategoryComboBox.setAlignmentY(0.0f);
        ((JLabel)((Object)this.ownListSubCategoryComboBox.getRenderer())).setHorizontalAlignment(0);
    }

    private void fillComboBoxes() {
        this.fillOwnListCategoryComboBox();
        this.ownListCategoryComboBox.setSelectedItem(this.ownList.getCategory());
        this.fillOwnListSubCategoryComboBox();
        this.ownListSubCategoryComboBox.setSelectedItem(this.ownList.getSubCategory());
    }

    private void fillOwnListCategoryComboBox() {
        this.ownListCategoryComboBox.removeAllItems();
        for (String string : this.ownListCategories) {
            this.ownListCategoryComboBox.addItem(string);
        }
    }

    private void fillOwnListSubCategoryComboBox() {
        this.ownListSubCategoryComboBox.removeAllItems();
        for (String string : this.ownListSubCategories) {
            this.ownListSubCategoryComboBox.addItem(string);
        }
    }

    private void initVocablesOfListPanel() {
        this.vocablesOfListPanel.setLayout(new VerticalLayout(3, 3));
    }

    private void initNameSelection() {
        SelectionsHelper.initSelectionAsEditor(this.nameSelection);
    }

    private void initToggleButton() {
        this.toggleMoveButtonsButton.addActionListener(actionEvent -> this.toggleMoveButtons());
    }

    private void toggleMoveButtons() {
        this.showMoveButtonsOnBars = !this.showMoveButtonsOnBars;
        this.setRightShowAndHideButtonTexts();
        this.showVocabelsInList();
    }

    private void setRightShowAndHideButtonTexts() {
        String string = "einblenden";
        String string2 = "ausblenden";
        String string3 = this.showMoveButtonsOnBars ? string2 : string;
        this.toggleMoveButtonsButton.setText("<html><center>Die Buttons zum Verschieben<br>" + string3 + "</center></html>");
    }

    private void showVocabelsInList() {
        this.vocablesOfListPanel.removeAll();
        for (Vocable vocable : this.vocables) {
            VocableBar vocableBar = new VocableBar(vocable, () -> this.deleteFromList(vocable), this);
            vocableBar.useButtonAsDeletion();
            vocableBar.showMoveButtonsOnBars(this.showMoveButtonsOnBars);
            vocableBar.showExtraDetailButtonOnTheLeft(() -> this.showDetails(vocable));
            vocableBar.createGui();
            this.vocablesOfListPanel.add(vocableBar.getPanel());
        }
        this.vocablesOfListPanel.repaint();
        this.vocablesOfListPanel.validate();
        this.vocablesOfListPanel.invalidate();
        this.vocablesOfListScroll.repaint();
        this.vocablesOfListScroll.validate();
        this.vocablesOfListScroll.invalidate();
    }

    private void deleteFromList(Vocable vocable) {
        Object object;
        this.vocables.remove(vocable);
        this.showVocabelsInList();
        if (this.barByVocable.containsKey(vocable)) {
            object = this.barByVocable.get(vocable);
            ((VocableBar)object).enable();
        }
        this.vocableFilter.requestFocusInSearchFieldLater();
        object = this.dataStructures.getOptions();
        if (((Options)object).isHideVocablesFromListInSearchAreaInOwnListEditor()) {
            this.filterVocables();
            int n = this.pages.getActualPageNumber();
            this.filterVocables();
            this.pages.showPage(n);
        }
    }

    private void filterVocables() {
        List<Vocable> list = this.vocableFilter.createFilteredVocablesList();
        this.reactOnFilteredVocables(list);
    }

    private void reactOnFilteredVocables(List<Vocable> list) {
        Options options = this.dataStructures.getOptions();
        List<Vocable> list2 = options.isHideVocablesFromListInSearchAreaInOwnListEditor() ? this.createCleanedFilteredVocablesList(list) : list;
        if (list2.isEmpty()) {
            GuiTools.informUser(this.getWindowAsComponent(), "Keine Vokabeln gefunden", "Die Suchkriterien f\u00fchren zu einer leeren Liste von Vokabeln, daher wird diese nicht angezeigt.");
        } else {
            this.pages.setOtherDatasets(list2);
        }
    }

    private List<Vocable> createCleanedFilteredVocablesList(List<Vocable> list) {
        ArrayList<Vocable> arrayList = new ArrayList<Vocable>();
        for (Vocable vocable : list) {
            if (this.vocables.contains(vocable)) continue;
            arrayList.add(vocable);
        }
        return arrayList;
    }

    @Override
    protected void populateDialog() {
        this.add(this.createVocableSelectionAndListPart(), "Center");
        this.add(this.createButtonPart(), "South");
        this.pages.addOwnExtension(this.createPagesExtensionPart());
    }

    private Component createVocableSelectionAndListPart() {
        Options options = this.dataStructures.getOptions();
        if (options.isUseSplitPaneInOwnListEditor()) {
            return this.createVocableSelectionAndListPartWithSplitPane();
        }
        return this.createVocableSelectionAndListPartWithFixSize();
    }

    private Component createVocableSelectionAndListPartWithSplitPane() {
        JSplitPane jSplitPane = new JSplitPane(1, this.createVocableSelectionPart(), this.createListPart());
        jSplitPane.setDividerLocation(1000);
        return jSplitPane;
    }

    private Component createVocableSelectionAndListPartWithFixSize() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createVocableSelectionPart(), "Center");
        jPanel.add(this.createListPart(), "East");
        return jPanel;
    }

    private Component createVocableSelectionPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        GuiTools.createTitle("Auswahl von Vokabeln", jPanel);
        jPanel.add((Component)this.vocableFilter.getPanel(), "North");
        jPanel.add(this.pages.getPanel(), "Center");
        return jPanel;
    }

    private Component createListPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        GuiTools.createTitle("Die Vokabelliste", jPanel);
        jPanel.add(this.createOwnListUpperPart(), "North");
        jPanel.add((Component)this.vocablesOfListScroll, "Center");
        return jPanel;
    }

    private Component createOwnListUpperPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createLeftOwnListUpperPart(), "West");
        jPanel.add(this.createRightOwnListUpperPart(), "East");
        return jPanel;
    }

    private Component createLeftOwnListUpperPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(3, 3));
        jPanel.add(this.nameSelection.getPanel());
        jPanel.add(this.createCategoryAndSubCategoryPart());
        return jPanel;
    }

    private Component createCategoryAndSubCategoryPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createCategoryAndSubCategoryComboBoxesPart(), "Center");
        jPanel.add(this.createEnterNewCategoryAndSubCategoryPart(), "East");
        return jPanel;
    }

    private Component createCategoryAndSubCategoryComboBoxesPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1, 2, 2));
        jPanel.setPreferredSize(new Dimension(300, 0));
        jPanel.add(this.ownListCategoryComboBox);
        jPanel.add(this.ownListSubCategoryComboBox);
        return jPanel;
    }

    private Component createEnterNewCategoryAndSubCategoryPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1, 2, 2));
        jPanel.add(this.createNewCategoryButton());
        jPanel.add(this.createNewSubCategoryButton());
        return jPanel;
    }

    private Component createNewCategoryButton() {
        JButton jButton = new JButton("neue Kategorie hinzuf\u00fcgen");
        jButton.addActionListener(actionEvent -> this.createNewOwnListCategory());
        return jButton;
    }

    private void createNewOwnListCategory() {
        String string = (String)this.ownListCategoryComboBox.getSelectedItem();
        String string2 = GuiTools.askUserToEnterAStringValue(this.getWindowAsComponent(), "Bitte geben sie die neue Kategorie ein", "Bitte geben sie die neue Kategorie ein.", string).strip();
        if (!string2.isBlank()) {
            if (!this.ownListCategories.contains(string2)) {
                this.ownListCategories.add(string2);
                this.fillOwnListCategoryComboBox();
            }
            this.ownListCategoryComboBox.setSelectedItem(string2);
        }
    }

    private Component createNewSubCategoryButton() {
        JButton jButton = new JButton("neue Unterkategorie hinzuf\u00fcgen");
        jButton.addActionListener(actionEvent -> this.createNewOwnListSubCategory());
        return jButton;
    }

    private void createNewOwnListSubCategory() {
        String string = (String)this.ownListSubCategoryComboBox.getSelectedItem();
        String string2 = GuiTools.askUserToEnterAStringValue(this.getWindowAsComponent(), "Bitte geben sie die neue Unterkategorie ein", "Bitte geben sie die neue Unterkategorie ein.", string).strip();
        if (!string2.isBlank()) {
            if (!this.ownListSubCategories.contains(string2)) {
                this.ownListSubCategories.add(string2);
                this.fillOwnListSubCategoryComboBox();
            }
            this.ownListSubCategoryComboBox.setSelectedItem(string2);
        }
    }

    private Component createRightOwnListUpperPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.toggleMoveButtonsButton, "East");
        return jPanel;
    }

    private Component createButtonPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createQuitButton(), "West");
        jPanel.add(this.createOkButton(), "East");
        return jPanel;
    }

    private Component createQuitButton() {
        JButton jButton = new JButton("Abbrechen");
        jButton.addActionListener(actionEvent -> this.quit());
        return jButton;
    }

    private void quit() {
        this.storeListOptions();
        this.closeDialog();
    }

    private Component createOkButton() {
        JButton jButton = new JButton(" Ok ");
        GuiTools.boldFont(jButton);
        GuiTools.biggerFont(jButton, 5);
        jButton.addActionListener(actionEvent -> this.apply());
        return jButton;
    }

    private void apply() {
        String string;
        String string2 = this.ownList.getName();
        String string3 = this.nameSelection.getTrimmedText();
        OwnLists ownLists = this.dataStructures.getOwnLists();
        if (!string3.equals(string2)) {
            if (string3.isBlank() || !ownLists.nameCheckOk(string3)) {
                GuiTools.informUser(this.getWindowAsComponent(), "Die Liste wurde nicht umbenannt", "Der eingegebene Name '" + string3 + "' ist bereits vorhanden oder resultiert in einem leeren Dateinamen.\nDie Liste wurde daher nicht umbenannt. Die restlichen \u00c4nderungen werden aber \u00fcbernommen.");
                string3 = string2;
            } else if (!string3.equals(string2)) {
                ownLists.renameListFile(string2, string3);
                this.ownList.setName(string3);
            }
        }
        if ((string = (String)this.ownListCategoryComboBox.getSelectedItem()).isBlank()) {
            string = "Default";
        }
        this.ownList.setCategory(string);
        String string4 = (String)this.ownListSubCategoryComboBox.getSelectedItem();
        if (string4.isBlank()) {
            string4 = "Default";
        }
        this.ownList.setSubCategory(string4);
        List<Vocable> list = this.ownList.getVocables();
        list.clear();
        list.addAll(this.vocables);
        ownLists.storeOwnLists();
        this.applied = true;
        this.quit();
        this.storeLastUsedOwnList();
    }

    private void storeLastUsedOwnList() {
        Options options = this.dataStructures.getOptions();
        HistoricalOwnListPersistanceDataList historicalOwnListPersistanceDataList = options.getHistoricalOwnLists();
        historicalOwnListPersistanceDataList.addOwnListData(this.ownList.toOwnListPersistanceData());
    }

    private void storeListOptions() {
        int n = this.pages.getNumberOfDatasetsPerPage();
        int n2 = this.pages.getNumberOfColumns();
        Options options = this.dataStructures.getOptions();
        options.setNumberOfDatasetsPerPageOfOwnListEditor(n);
        options.setNumberOfColumnsOfOwnListEditor(n2);
        Point point = this.getLocation();
        Dimension dimension = this.getSizeOfWindow();
        options.setLocationOfOwnListEditor(point);
        options.setSizeOfOwnListEditor(dimension);
        OwnLists ownLists = this.dataStructures.getOwnLists();
        ownLists.saveOptions();
    }

    private Component createPagesExtensionPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 3, 3));
        jPanel.add(this.createOptionsButton());
        jPanel.add(this.createSelectAllButton());
        jPanel.add(this.createDeselectAllButton());
        jPanel.add(this.createAddSelectedButton());
        jPanel.add(this.createAddAllButton());
        return jPanel;
    }

    private Component createOptionsButton() {
        JButton jButton = new JButton("Options");
        jButton.addActionListener(actionEvent -> this.showOptions());
        return jButton;
    }

    private void showOptions() {
        OptionsDialog optionsDialog = new OptionsDialog(this.dataStructures.getOptions(), this.getLocation(), this.uiObjects);
        optionsDialog.showOnlyOwnListDialogOptions();
        optionsDialog.populate();
        optionsDialog.setVisible(true);
        if (optionsDialog.wasApplied()) {
            this.runAfterChangingOptions();
        }
    }

    private void runAfterChangingOptions() {
        OwnLists ownLists = this.dataStructures.getOwnLists();
        ownLists.saveOptions();
        this.filterVocables();
    }

    private Component createSelectAllButton() {
        JButton jButton = new JButton("select all");
        jButton.addActionListener(actionEvent -> this.selectAll());
        return jButton;
    }

    private void selectAll() {
        boolean bl = true;
        this.setBarsOnActualPageSelected(bl);
    }

    private Component createDeselectAllButton() {
        JButton jButton = new JButton("deselect all");
        jButton.addActionListener(actionEvent -> this.deselectAll());
        return jButton;
    }

    private void deselectAll() {
        boolean bl = false;
        this.setBarsOnActualPageSelected(bl);
    }

    private void setBarsOnActualPageSelected(boolean bl) {
        for (Vocable vocable : this.pages.getDatasetsFromActualPage()) {
            VocableBar vocableBar = this.barByVocable.get(vocable);
            vocableBar.setSelected(bl);
        }
    }

    private Component createAddSelectedButton() {
        JButton jButton = new JButton("add selected");
        jButton.addActionListener(actionEvent -> this.addSelected());
        return jButton;
    }

    private void addSelected() {
        ArrayList<VocableBar> arrayList = new ArrayList<VocableBar>();
        for (Vocable vocable : this.pages.getDatasetsFromActualPage()) {
            VocableBar vocableBar = this.barByVocable.get(vocable);
            if (!vocableBar.isSelected()) continue;
            this.addVocable(vocable);
            arrayList.add(vocableBar);
        }
        this.disableAddedBars(arrayList);
    }

    private Component createAddAllButton() {
        JButton jButton = new JButton("add all from active Page");
        jButton.addActionListener(actionEvent -> this.addAll());
        return jButton;
    }

    private void addAll() {
        ArrayList<VocableBar> arrayList = new ArrayList<VocableBar>();
        for (Vocable vocable : this.pages.getDatasetsFromActualPage()) {
            this.addVocable(vocable);
            VocableBar vocableBar = this.barByVocable.get(vocable);
            arrayList.add(vocableBar);
        }
        this.disableAddedBars(arrayList);
    }

    private void disableAddedBars(List<VocableBar> list) {
        for (VocableBar vocableBar : list) {
            vocableBar.setSelected(false);
            vocableBar.disable();
        }
    }

    @Override
    public void moveBarToFirst(Vocable vocable) {
        int n = this.vocables.indexOf(vocable);
        this.vocables.remove(n);
        this.vocables.add(0, vocable);
        this.showVocabelsInList();
    }

    @Override
    public void moveBarUp(Vocable vocable) {
        int n = this.vocables.indexOf(vocable);
        this.vocables.remove(n);
        this.vocables.add(n - 1, vocable);
        this.showVocabelsInList();
    }

    @Override
    public void moveBarDown(Vocable vocable) {
        int n = this.vocables.indexOf(vocable);
        this.vocables.remove(n);
        this.vocables.add(n + 1, vocable);
        this.showVocabelsInList();
    }

    @Override
    public void moveBarToLast(Vocable vocable) {
        int n = this.vocables.indexOf(vocable);
        this.vocables.remove(n);
        this.vocables.add(vocable);
        this.showVocabelsInList();
    }

    @Override
    public boolean canBarMoveUp(Vocable vocable) {
        int n = this.vocables.indexOf(vocable);
        return n > 0;
    }

    @Override
    public boolean canBarMoveDown(Vocable vocable) {
        int n = this.vocables.indexOf(vocable);
        return n < this.vocables.size() - 1;
    }

    public boolean isApplied() {
        return this.applied;
    }
}

