/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.dialog.table.kanji;

import de.duehl.basics.datetime.date.ImmutualDate;
import de.duehl.basics.text.Text;
import de.duehl.vocabulary.japanese.common.color.VocableColors;
import de.duehl.vocabulary.japanese.common.data.InternalAdditionalKanjiData;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.data.FumikoDataStructures;
import de.duehl.vocabulary.japanese.data.symbol.Kanji;
import de.duehl.vocabulary.japanese.logic.symbol.kanji.internal.InternalKanjiDataRequester;
import de.duehl.vocabulary.japanese.ui.dialog.table.TableHelper;
import java.awt.Color;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class KanjiTableModel
extends AbstractTableModel {
    private static final int NUMBER_OF_COLUMNS = 17;
    private static final long serialVersionUID = 1L;
    private final List<Kanji> kanjiList;
    private final Options options;
    private final InternalKanjiDataRequester requester;

    public KanjiTableModel(List<Kanji> list, FumikoDataStructures fumikoDataStructures) {
        this.kanjiList = list;
        this.options = fumikoDataStructures.getOptions();
        this.requester = fumikoDataStructures.getInternalKanjiDataRequester();
    }

    @Override
    public int getRowCount() {
        return this.kanjiList.size();
    }

    @Override
    public int getColumnCount() {
        return 17;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 9 || n2 == 16;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Kanji kanji = this.kanjiList.get(n);
        InternalAdditionalKanjiData internalAdditionalKanjiData = this.requester.getInternalDataForKanji(kanji);
        switch (n2) {
            case 0: {
                return n + 1;
            }
            case 1: {
                return kanji.getCharacter();
            }
            case 2: {
                return kanji.getGermanMeaning();
            }
            case 3: {
                return kanji.getNormalKanjiHiraganaWord();
            }
            case 4: {
                return kanji.getNormalHiraganaWord();
            }
            case 5: {
                return kanji.getNumberInKanjiAndKanaBook();
            }
            case 6: {
                return kanji.getPageNumberInKanjiAndKanaBook();
            }
            case 7: {
                return Text.join(", ", kanji.getOnLesungen());
            }
            case 8: {
                return Text.join(", ", kanji.getKunLesungen());
            }
            case 9: {
                return "Vokabeln mit dem Kanji anzeigen";
            }
            case 10: {
                return internalAdditionalKanjiData.getFirstSeenDate();
            }
            case 11: {
                return internalAdditionalKanjiData.getTestCount();
            }
            case 12: {
                return internalAdditionalKanjiData.getCorrectTestCount();
            }
            case 13: {
                return TableHelper.dateOrEmpty(internalAdditionalKanjiData.getLastTestDate(), internalAdditionalKanjiData.getTestCount());
            }
            case 14: {
                return TableHelper.dateOrEmpty(internalAdditionalKanjiData.getLastCorrectTestDate(), internalAdditionalKanjiData.getCorrectTestCount());
            }
            case 15: {
                return TableHelper.createMonospaceHtml(internalAdditionalKanjiData.getLastTenTestResultsAsStorageString());
            }
            case 16: {
                return "Details";
            }
        }
        throw new RuntimeException("Unzul\u00e4siger Spaltenindex '" + n2 + "'.");
    }

    @Override
    public Class<?> getColumnClass(int n) {
        switch (n) {
            case 0: 
            case 5: 
            case 6: 
            case 11: 
            case 12: {
                return Integer.class;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 15: {
                return String.class;
            }
            case 10: 
            case 13: 
            case 14: {
                return ImmutualDate.class;
            }
        }
        return String.class;
    }

    public Color determineRowForegroundColor(int n) {
        Kanji kanji = this.kanjiList.get(n);
        InternalAdditionalKanjiData internalAdditionalKanjiData = this.requester.getInternalDataForKanji(kanji);
        VocableColors vocableColors = new VocableColors(this.options);
        return vocableColors.determineKanjiForegroundColor(internalAdditionalKanjiData, true);
    }

    public Color determineRowBackgroundColor(int n) {
        Kanji kanji = this.kanjiList.get(n);
        InternalAdditionalKanjiData internalAdditionalKanjiData = this.requester.getInternalDataForKanji(kanji);
        VocableColors vocableColors = new VocableColors(this.options);
        return vocableColors.determineKanjiBackgroundColor(internalAdditionalKanjiData, true);
    }
}

