/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.dialog.testing;

import de.duehl.basics.text.NumberString;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.dialogs.base.ModalDialogBase;
import de.duehl.swing.ui.layout.VerticalLayout;
import de.duehl.vocabulary.japanese.common.color.VocableColors;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.ui.tools.VocabularyTrainerUiTools;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class AllTranslationsEvaluationDialog
extends ModalDialogBase {
    private final String message;
    private final Color backgroundColor;
    private final JButton quitButton;
    private final String originalDialogTitle;
    private final double lastTenTestsPercentBefore;
    private final double lastTenTestsPercentAfter;
    private final double actualPercent;
    private String actualPercentTextWithTwoDigitsAfterComma;

    public AllTranslationsEvaluationDialog(Options options, int n, int n2, Point point, Image image, double d, double d2, String string) {
        super(point, image, "Auswertung der \u00dcbersetzungen (" + string + ")");
        this.lastTenTestsPercentBefore = d;
        this.lastTenTestsPercentAfter = d2;
        this.originalDialogTitle = string;
        this.addEscapeBehaviour();
        this.message = VocabularyTrainerUiTools.createAllTestsMessage("Vokabeln", "\u00fcbersetzt", n, n2);
        VocableColors vocableColors = new VocableColors(options);
        this.backgroundColor = vocableColors.determineBackgroundColor(n, n2);
        this.actualPercent = NumberString.percentAsNumber(n2, n);
        this.actualPercentTextWithTwoDigitsAfterComma = NumberString.percent(n2, n);
        this.quitButton = new JButton("Beenden");
        this.fillDialog();
    }

    @Override
    protected void populateDialog() {
        this.initElements();
        this.add(this.createCenterPart(), "Center");
        this.add(this.createButtonsPart(), "South");
        this.pack();
        SwingUtilities.invokeLater(() -> this.quitButton.requestFocus());
    }

    private void initElements() {
        GuiTools.addReturnListener(this.quitButton, () -> this.quitButton.doClick());
    }

    private Component createCenterPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(0, 3));
        jPanel.add(this.createMessagePart());
        jPanel.add(this.createTestedVocablesInfoPart());
        return GuiTools.createScrollPane(jPanel);
    }

    private Component createMessagePart() {
        JLabel jLabel = new JLabel("<html>" + this.message + "</html>");
        GuiTools.biggerFont(jLabel, 5);
        jLabel.setOpaque(true);
        jLabel.setBackground(this.backgroundColor);
        return jLabel;
    }

    private Component createTestedVocablesInfoPart() {
        String string = "Abgefragte Vokabeln: " + this.originalDialogTitle;
        String string2 = "Erfolg der aktuellen Abfrage in Prozent: " + this.actualPercentTextWithTwoDigitsAfterComma;
        String string3 = "Erfolg der letzten Zehn Abfragen VOR der aktuellen Abfrage in Prozent: " + NumberString.twoDecimalPlaces(this.lastTenTestsPercentBefore);
        String string4 = "Erfolg der letzten Zehn Abfragen NACH der aktuellen Abfrage in Prozent: " + NumberString.twoDecimalPlaces(this.lastTenTestsPercentAfter);
        String string5 = this.actualPercent > this.lastTenTestsPercentBefore ? "Sie haben sich verbessert." : (this.actualPercent < this.lastTenTestsPercentBefore ? "Sie haben sich verschlechtert." : "Sie waren genauso gut wie vorher.");
        String string6 = "<html><br/>" + string + "<br/>" + string2 + "<br/>" + string5 + "<br/><br/>" + string3 + "<br/>" + string4 + "</html>";
        JLabel jLabel = new JLabel(string6);
        GuiTools.biggerFont(jLabel, 5);
        jLabel.setOpaque(true);
        jLabel.setBackground(this.backgroundColor);
        return jLabel;
    }

    private Component createButtonsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createQuitButton(), "East");
        return jPanel;
    }

    private Component createQuitButton() {
        this.quitButton.addActionListener(actionEvent -> this.closeDialog());
        this.quitButton.setBackground(this.backgroundColor);
        return this.quitButton;
    }
}

