/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.dialog.update;

import de.duehl.basics.text.html.HtmlTool;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.dialogs.base.ModalDialogBase;
import de.duehl.swing.ui.layout.VerticalLayout;
import de.duehl.vocabulary.japanese.logic.ownlists.groups.OwnListGroup;
import de.duehl.vocabulary.japanese.ui.dialog.update.bar.GroupBar;
import de.duehl.vocabulary.japanese.website.update.ownlists.OwnListGroupsUpdater;
import de.duehl.vocabulary.japanese.website.update.ownlists.data.NewestOwnListVersionListEntry;
import de.duehl.vocabulary.japanese.website.update.ownlists.data.OwnListInterestAndVersionEntry;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class OwnListInterestSelectionAndDownloadDialog
extends ModalDialogBase {
    private List<NewestOwnListVersionListEntry> newestOwnListVersionEntries;
    private final List<OwnListInterestAndVersionEntry> interestAndVersionEntries;
    private final List<String> newerOrUnseenGroupNames;
    private boolean applied;
    private final List<GroupBar> bars;

    public OwnListInterestSelectionAndDownloadDialog(List<NewestOwnListVersionListEntry> list, List<OwnListInterestAndVersionEntry> list2, List<String> list3, Point point, Image image) {
        super(point, image, "Einstellung der Interessen und Download aktualisierter oder neuer Gruppen");
        this.newestOwnListVersionEntries = list;
        this.interestAndVersionEntries = list2;
        this.newerOrUnseenGroupNames = list3;
        this.bars = new ArrayList<GroupBar>();
        this.applied = false;
        this.initElements();
        this.fillDialog();
    }

    private void initElements() {
        this.initBars();
    }

    private void initBars() {
        for (NewestOwnListVersionListEntry newestOwnListVersionListEntry : this.newestOwnListVersionEntries) {
            GroupBar groupBar = this.createBar(newestOwnListVersionListEntry);
            this.bars.add(groupBar);
        }
    }

    private GroupBar createBar(NewestOwnListVersionListEntry newestOwnListVersionListEntry) {
        String string = newestOwnListVersionListEntry.getGroupName();
        String string2 = this.determineGroupDescription(string);
        int n = newestOwnListVersionListEntry.getVersion();
        boolean bl = this.newerOrUnseenGroupNames.contains(string);
        boolean bl2 = !this.newerOrUnseenGroupNames.isEmpty();
        boolean bl3 = this.isUserInterestedInGroup(string);
        GroupBar groupBar = new GroupBar(string, string2, n, bl, bl2, bl3);
        return groupBar;
    }

    private String determineGroupDescription(String string) {
        OwnListGroup ownListGroup = OwnListGroup.createByGroupName(string);
        return ownListGroup.getDescription();
    }

    private boolean isUserInterestedInGroup(String string) {
        OwnListInterestAndVersionEntry ownListInterestAndVersionEntry = OwnListGroupsUpdater.findOwnListInterestAndVersionEntryByGroupname(string, this.interestAndVersionEntries);
        if (OwnListGroupsUpdater.NOT_FOUND_INTEREST_AND_VERSION.equals(ownListInterestAndVersionEntry)) {
            return false;
        }
        return ownListInterestAndVersionEntry.isInterested();
    }

    @Override
    protected void populateDialog() {
        this.add(this.createCenterPart(), "Center");
        this.add(this.createButtonsPart(), "South");
    }

    private Component createCenterPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        GuiTools.createTitle(jPanel);
        jPanel.add(this.createIntroPart(), "North");
        jPanel.add(this.createGroupsPart(), "Center");
        return jPanel;
    }

    private Component createIntroPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(5, 3));
        JLabel jLabel = new JLabel("Es gibt Neuerungen bei den Gruppen mit eigenen Listen.");
        GuiTools.biggerFont(jLabel, 7);
        jPanel.add(jLabel);
        JLabel jLabel2 = new JLabel(HtmlTool.htmlify("In diesem Dialog kann sowohl das generelle Interesse an den Gruppen ge\u00e4ndert wie auch festgelegt werden, welche Gruppen an eigenen Listen heruntergeladen und importiert werden sollen.", 120));
        jPanel.add(jLabel2);
        return jPanel;
    }

    private Component createGroupsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(5, 3));
        for (GroupBar groupBar : this.bars) {
            jPanel.add(groupBar.getPanel());
        }
        return jPanel;
    }

    private Component createButtonsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createQuitButton(), "West");
        jPanel.add(this.createOKButton(), "East");
        return jPanel;
    }

    private Component createQuitButton() {
        JButton jButton = new JButton("Abbrechen");
        jButton.addActionListener(actionEvent -> this.closeDialog());
        return jButton;
    }

    private Component createOKButton() {
        JButton jButton = new JButton("OK");
        jButton.addActionListener(actionEvent -> this.apply());
        return jButton;
    }

    private void apply() {
        this.applied = true;
        this.closeDialog();
    }

    public boolean isApplied() {
        return this.applied;
    }

    public List<String> getGroupNamesInterestedIn() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (GroupBar groupBar : this.bars) {
            if (!groupBar.isInterested()) continue;
            arrayList.add(groupBar.getGroupName());
        }
        return arrayList;
    }

    public List<String> getGroupNamesToDownload() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (GroupBar groupBar : this.bars) {
            if (!groupBar.download()) continue;
            arrayList.add(groupBar.getGroupName());
        }
        return arrayList;
    }
}

