/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.filter;

import de.duehl.swing.ui.components.selections.SearchWordStringSelection;
import de.duehl.swing.ui.components.selections.SelectionsHelper;
import de.duehl.swing.ui.components.selections.data.SearchWordSelectionInputs;
import de.duehl.swing.ui.layout.VerticalLayout;
import de.duehl.vocabulary.japanese.data.FumikoDataStructures;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.data.Vocabulary;
import de.duehl.vocabulary.japanese.logic.ownlists.OwnLists;
import de.duehl.vocabulary.japanese.logic.sort.VocableSorter;
import de.duehl.vocabulary.japanese.tools.VocabularyTools;
import de.duehl.vocabulary.japanese.ui.filter.FilteredVocablesReactor;
import de.duehl.vocabulary.japanese.ui.filter.VocableFilterInputs;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class VocableFilterPanel {
    private static final String ALL_CATEGORY = "Alle Kategorien";
    private static final String ALL_SUB_CATEGORY = "Alle Unterkategorien";
    private static final String ALL_SEARCH_WORDS = "Alle Suchbegriffe";
    private static final String ALL_PARTS_OF_SPEACH = "Alle Wortarten";
    private static final String ALL_VOCABULARIES = "Alle Vokabulare";
    private final FumikoDataStructures dataStructures;
    private final FilteredVocablesReactor filteredVocablesReactor;
    private final JPanel panel;
    private final JComboBox<String> categoryFilterComboBox;
    private final JComboBox<String> subCategoryFilterComboBox;
    private final JComboBox<String> vocabularyDescriptionFilterComboBox;
    private final JComboBox<String> searchWordFilterComboBox;
    private final JComboBox<String> partsOfSpeechFilterComboBox;
    private final SearchWordStringSelection kanaSearchFilterStringSelection;
    private final SearchWordStringSelection kanjiSearchFilterStringSelection;
    private final SearchWordStringSelection romajiSearchFilterStringSelection;
    private final SearchWordStringSelection pronunciationSearchFilterStringSelection;
    private final SearchWordStringSelection translationSearchFilterStringSelection;
    private final SearchWordStringSelection commentSearchFilterStringSelection;
    private final SearchWordStringSelection searchWordSearchFilterStringSelection;
    private final SearchWordStringSelection partOfSpeechSearchFilterStringSelection;
    private final SearchWordStringSelection searchFilterStringSelection;
    private final JButton searchButton;
    private final JButton resetButton;
    private boolean filteringActive;
    private final JCheckBox comboBoxesAreActiveCheckBox;

    public VocableFilterPanel(FumikoDataStructures fumikoDataStructures, FilteredVocablesReactor filteredVocablesReactor) {
        this.dataStructures = fumikoDataStructures;
        this.filteredVocablesReactor = filteredVocablesReactor;
        this.panel = new JPanel();
        this.categoryFilterComboBox = new JComboBox();
        this.subCategoryFilterComboBox = new JComboBox();
        this.searchWordFilterComboBox = new JComboBox();
        this.partsOfSpeechFilterComboBox = new JComboBox();
        this.vocabularyDescriptionFilterComboBox = new JComboBox();
        this.kanaSearchFilterStringSelection = new SearchWordStringSelection("Suche in den Kana der Vokabeln");
        this.kanjiSearchFilterStringSelection = new SearchWordStringSelection("Suche in den Kanji der Vokabeln");
        this.romajiSearchFilterStringSelection = new SearchWordStringSelection("Suche in den Romaji der Vokabeln");
        this.pronunciationSearchFilterStringSelection = new SearchWordStringSelection("Suche in den Aussprachen der Vokabeln");
        this.translationSearchFilterStringSelection = new SearchWordStringSelection("Suche in den \u00dcbersetzungen der Vokabeln");
        this.commentSearchFilterStringSelection = new SearchWordStringSelection("Suche in den Kommentaren der Vokabeln");
        this.searchWordSearchFilterStringSelection = new SearchWordStringSelection("Suche in den Suchbegriffen der Vokabeln");
        this.partOfSpeechSearchFilterStringSelection = new SearchWordStringSelection("Suche in den Wortarten der Vokabeln");
        this.searchFilterStringSelection = new SearchWordStringSelection("Suche in beliebigen Daten der Vokabeln");
        this.searchButton = new JButton("filtern");
        this.resetButton = new JButton("Felder leeren");
        this.comboBoxesAreActiveCheckBox = new JCheckBox();
        this.filteringActive = true;
        this.init();
    }

    private void init() {
        this.initComboBoxes();
        this.fillComboBoxes();
        this.addComboboxesActionListeners();
        this.initSearchFields();
        this.initButtons();
        this.initCheckBoxes();
    }

    private void initComboBoxes() {
        this.categoryFilterComboBox.setAlignmentX(0.0f);
        this.categoryFilterComboBox.setAlignmentY(0.0f);
        ((JLabel)((Object)this.categoryFilterComboBox.getRenderer())).setHorizontalAlignment(0);
        this.subCategoryFilterComboBox.setAlignmentX(0.0f);
        this.subCategoryFilterComboBox.setAlignmentY(0.0f);
        ((JLabel)((Object)this.subCategoryFilterComboBox.getRenderer())).setHorizontalAlignment(0);
        this.searchWordFilterComboBox.setAlignmentX(0.0f);
        this.searchWordFilterComboBox.setAlignmentY(0.0f);
        ((JLabel)((Object)this.searchWordFilterComboBox.getRenderer())).setHorizontalAlignment(0);
        this.partsOfSpeechFilterComboBox.setAlignmentX(0.0f);
        this.partsOfSpeechFilterComboBox.setAlignmentY(0.0f);
        ((JLabel)((Object)this.partsOfSpeechFilterComboBox.getRenderer())).setHorizontalAlignment(0);
        this.vocabularyDescriptionFilterComboBox.setAlignmentX(0.0f);
        this.vocabularyDescriptionFilterComboBox.setAlignmentY(0.0f);
        ((JLabel)((Object)this.vocabularyDescriptionFilterComboBox.getRenderer())).setHorizontalAlignment(0);
    }

    private void fillComboBoxes() {
        this.fillCategoryComboBox();
        this.fillSubCategoryComboBox();
        this.fillSearchWordFilterComboBox();
        this.fillPartsOfSpeechFilterComboBox();
        this.fillVocabularyDescriptionComboBox();
    }

    private void fillCategoryComboBox() {
        this.categoryFilterComboBox.addItem(ALL_CATEGORY);
        for (String string : VocabularyTools.determineCategories(this.dataStructures.getVocabularies())) {
            this.categoryFilterComboBox.addItem(string);
        }
    }

    private void fillSubCategoryComboBox() {
        this.subCategoryFilterComboBox.removeAllItems();
        String string = (String)this.categoryFilterComboBox.getSelectedItem();
        boolean bl = string == null || string.equals(ALL_CATEGORY);
        this.subCategoryFilterComboBox.addItem(ALL_SUB_CATEGORY);
        List<String> list = bl ? VocabularyTools.determineSubCategories(this.dataStructures.getVocabularies()) : VocabularyTools.determineSubCategoriesOfCategory(this.dataStructures.getVocabularies(), string);
        for (String string2 : list) {
            this.subCategoryFilterComboBox.addItem(string2);
        }
    }

    private void fillSearchWordFilterComboBox() {
        this.searchWordFilterComboBox.addItem(ALL_SEARCH_WORDS);
        OwnLists ownLists = this.dataStructures.getOwnLists();
        for (String string : ownLists.getSearchWords()) {
            this.searchWordFilterComboBox.addItem(string);
        }
    }

    private void fillPartsOfSpeechFilterComboBox() {
        this.partsOfSpeechFilterComboBox.addItem(ALL_PARTS_OF_SPEACH);
        OwnLists ownLists = this.dataStructures.getOwnLists();
        for (String string : ownLists.getPartsOfSpeach()) {
            this.partsOfSpeechFilterComboBox.addItem(string);
        }
    }

    private void fillVocabularyDescriptionComboBox() {
        this.vocabularyDescriptionFilterComboBox.removeAllItems();
        this.vocabularyDescriptionFilterComboBox.addItem(ALL_VOCABULARIES);
        String string = (String)this.categoryFilterComboBox.getSelectedItem();
        String string2 = (String)this.subCategoryFilterComboBox.getSelectedItem();
        boolean bl = string == null || string.equals(ALL_CATEGORY);
        boolean bl2 = string2 == null || string2.equals(ALL_SUB_CATEGORY);
        for (Vocabulary vocabulary : this.dataStructures.getVocabularies()) {
            boolean bl3;
            String string3 = vocabulary.getCategory();
            String string4 = vocabulary.getSubCategory();
            boolean bl4 = bl || string.equals(string3);
            boolean bl5 = bl3 = bl2 || string2.equals(string4);
            if (!bl4 || !bl3) continue;
            this.vocabularyDescriptionFilterComboBox.addItem(vocabulary.getDescription());
        }
    }

    private void addComboboxesActionListeners() {
        this.categoryFilterComboBox.addActionListener(actionEvent -> this.categoryFilterChanged());
        this.subCategoryFilterComboBox.addActionListener(actionEvent -> this.subCategoryFilterChanged());
        this.searchWordFilterComboBox.addActionListener(actionEvent -> this.vocabularyFilterChanged());
        this.partsOfSpeechFilterComboBox.addActionListener(actionEvent -> this.vocabularyFilterChanged());
        this.vocabularyDescriptionFilterComboBox.addActionListener(actionEvent -> this.vocabularyFilterChanged());
    }

    private void categoryFilterChanged() {
        this.fillSubCategoryComboBox();
        this.fillVocabularyDescriptionComboBox();
        this.filterVocables();
    }

    private void subCategoryFilterChanged() {
        this.fillVocabularyDescriptionComboBox();
        this.filterVocables();
    }

    private void vocabularyFilterChanged() {
        this.filterVocables();
    }

    private void filterVocables() {
        if (this.filteringActive) {
            List<Vocable> list = this.createFilteredVocablesList();
            this.sort(list);
            this.filteredVocablesReactor.reactOnFilteredVocables(list);
        }
    }

    public List<Vocable> createFilteredVocablesList() {
        boolean bl;
        ArrayList<Vocable> arrayList = new ArrayList<Vocable>();
        String string = (String)this.categoryFilterComboBox.getSelectedItem();
        String string2 = (String)this.subCategoryFilterComboBox.getSelectedItem();
        String string3 = (String)this.searchWordFilterComboBox.getSelectedItem();
        String string4 = (String)this.partsOfSpeechFilterComboBox.getSelectedItem();
        String string5 = (String)this.vocabularyDescriptionFilterComboBox.getSelectedItem();
        boolean bl2 = string == null || string.equals(ALL_CATEGORY);
        boolean bl3 = string2 == null || string2.equals(ALL_SUB_CATEGORY);
        boolean bl4 = string3 == null || string3.equals(ALL_SEARCH_WORDS);
        boolean bl5 = string4 == null || string4.equals(ALL_PARTS_OF_SPEACH);
        boolean bl6 = bl = string5 == null || string5.equals(ALL_VOCABULARIES);
        if (!this.comboBoxesAreActiveCheckBox.isSelected()) {
            bl2 = true;
            bl3 = true;
            bl4 = true;
            bl5 = true;
            bl = true;
        }
        SearchWordSelectionInputs searchWordSelectionInputs = this.kanaSearchFilterStringSelection.getInputs();
        SearchWordSelectionInputs searchWordSelectionInputs2 = this.kanjiSearchFilterStringSelection.getInputs();
        SearchWordSelectionInputs searchWordSelectionInputs3 = this.romajiSearchFilterStringSelection.getInputs();
        SearchWordSelectionInputs searchWordSelectionInputs4 = this.pronunciationSearchFilterStringSelection.getInputs();
        SearchWordSelectionInputs searchWordSelectionInputs5 = this.translationSearchFilterStringSelection.getInputs();
        SearchWordSelectionInputs searchWordSelectionInputs6 = this.commentSearchFilterStringSelection.getInputs();
        SearchWordSelectionInputs searchWordSelectionInputs7 = this.searchWordSearchFilterStringSelection.getInputs();
        SearchWordSelectionInputs searchWordSelectionInputs8 = this.partOfSpeechSearchFilterStringSelection.getInputs();
        SearchWordSelectionInputs searchWordSelectionInputs9 = this.searchFilterStringSelection.getInputs();
        for (Vocabulary vocabulary : this.dataStructures.getVocabularies()) {
            boolean bl7;
            String string6 = vocabulary.getCategory();
            String string7 = vocabulary.getSubCategory();
            boolean bl8 = bl2 || string.equals(string6);
            boolean bl9 = bl7 = bl3 || string2.equals(string7);
            if (!bl8 || !bl7) continue;
            String string8 = vocabulary.getDescription();
            if (!bl && !string5.equals(string8)) continue;
            for (Vocable vocable : vocabulary.getVocables()) {
                boolean bl10;
                List<String> list = vocable.getSearchWords();
                List<String> list2 = vocable.getPartsOfSpeech();
                boolean bl11 = bl4 || list.contains(string3);
                boolean bl12 = bl5 || list2.contains(string4);
                boolean bl13 = searchWordSelectionInputs.isTextEmpty() || vocable.kanaContains(searchWordSelectionInputs);
                boolean bl14 = searchWordSelectionInputs2.isTextEmpty() || vocable.kanjiContains(searchWordSelectionInputs2);
                boolean bl15 = searchWordSelectionInputs3.isTextEmpty() || vocable.romajiContains(searchWordSelectionInputs3);
                boolean bl16 = searchWordSelectionInputs4.isTextEmpty() || vocable.pronunciationContains(searchWordSelectionInputs4);
                boolean bl17 = searchWordSelectionInputs5.isTextEmpty() || vocable.translationsContains(searchWordSelectionInputs5);
                boolean bl18 = searchWordSelectionInputs6.isTextEmpty() || vocable.commentContains(searchWordSelectionInputs6);
                boolean bl19 = searchWordSelectionInputs7.isTextEmpty() || vocable.searchWordsContains(searchWordSelectionInputs7);
                boolean bl20 = searchWordSelectionInputs8.isTextEmpty() || vocable.partOfSpeechContains(searchWordSelectionInputs8);
                boolean bl21 = bl10 = searchWordSelectionInputs9.isTextEmpty() || vocable.contains(searchWordSelectionInputs9);
                if (!bl11 || !bl12 || !bl13 || !bl14 || !bl15 || !bl16 || !bl17 || !bl18 || !bl19 || !bl20 || !bl10) continue;
                arrayList.add(vocable);
            }
        }
        return arrayList;
    }

    private void sort(List<Vocable> list) {
        String string = this.getRelevantSearchWord();
        if (!string.isBlank()) {
            VocableSorter vocableSorter = new VocableSorter(list, string);
            vocableSorter.sort();
        }
    }

    private String getRelevantSearchWord() {
        SearchWordSelectionInputs searchWordSelectionInputs = this.kanaSearchFilterStringSelection.getInputs();
        SearchWordSelectionInputs searchWordSelectionInputs2 = this.kanjiSearchFilterStringSelection.getInputs();
        SearchWordSelectionInputs searchWordSelectionInputs3 = this.romajiSearchFilterStringSelection.getInputs();
        SearchWordSelectionInputs searchWordSelectionInputs4 = this.pronunciationSearchFilterStringSelection.getInputs();
        SearchWordSelectionInputs searchWordSelectionInputs5 = this.translationSearchFilterStringSelection.getInputs();
        SearchWordSelectionInputs searchWordSelectionInputs6 = this.commentSearchFilterStringSelection.getInputs();
        SearchWordSelectionInputs searchWordSelectionInputs7 = this.searchWordSearchFilterStringSelection.getInputs();
        SearchWordSelectionInputs searchWordSelectionInputs8 = this.partOfSpeechSearchFilterStringSelection.getInputs();
        SearchWordSelectionInputs searchWordSelectionInputs9 = this.searchFilterStringSelection.getInputs();
        if (!searchWordSelectionInputs.isTextEmpty()) {
            return searchWordSelectionInputs.getText();
        }
        if (!searchWordSelectionInputs2.isTextEmpty()) {
            return searchWordSelectionInputs2.getText();
        }
        if (!searchWordSelectionInputs3.isTextEmpty()) {
            return searchWordSelectionInputs3.getText();
        }
        if (!searchWordSelectionInputs4.isTextEmpty()) {
            return searchWordSelectionInputs4.getText();
        }
        if (!searchWordSelectionInputs5.isTextEmpty()) {
            return searchWordSelectionInputs5.getText();
        }
        if (!searchWordSelectionInputs6.isTextEmpty()) {
            return searchWordSelectionInputs6.getText();
        }
        if (!searchWordSelectionInputs7.isTextEmpty()) {
            return searchWordSelectionInputs7.getText();
        }
        if (!searchWordSelectionInputs8.isTextEmpty()) {
            return searchWordSelectionInputs8.getText();
        }
        if (!searchWordSelectionInputs9.isTextEmpty()) {
            return searchWordSelectionInputs9.getText();
        }
        return "";
    }

    private void initSearchFields() {
        this.initSearchWordStringSelection(this.kanaSearchFilterStringSelection);
        this.initSearchWordStringSelection(this.kanjiSearchFilterStringSelection);
        this.initSearchWordStringSelection(this.romajiSearchFilterStringSelection);
        this.initSearchWordStringSelection(this.pronunciationSearchFilterStringSelection);
        this.initSearchWordStringSelection(this.translationSearchFilterStringSelection);
        this.initSearchWordStringSelection(this.commentSearchFilterStringSelection);
        this.initSearchWordStringSelection(this.searchWordSearchFilterStringSelection);
        this.initSearchWordStringSelection(this.partOfSpeechSearchFilterStringSelection);
        this.initSearchWordStringSelection(this.searchFilterStringSelection);
        this.requestFocusInSearchFieldLater();
    }

    private void initSearchWordStringSelection(SearchWordStringSelection searchWordStringSelection) {
        searchWordStringSelection.addReturnListener(() -> this.searchButton.doClick());
        searchWordStringSelection.biggerText(5);
        SelectionsHelper.initSelectionAsEditor(searchWordStringSelection);
        searchWordStringSelection.setCheckboxesFocusable(false);
    }

    private void initButtons() {
        this.searchButton.addActionListener(actionEvent -> this.filterVocables());
        this.resetButton.addActionListener(actionEvent -> this.reset());
    }

    private void reset() {
        this.filteringActive = false;
        this.categoryFilterComboBox.setSelectedIndex(0);
        this.subCategoryFilterComboBox.setSelectedIndex(0);
        this.vocabularyDescriptionFilterComboBox.setSelectedIndex(0);
        this.searchWordFilterComboBox.setSelectedIndex(0);
        this.partsOfSpeechFilterComboBox.setSelectedIndex(0);
        SearchWordSelectionInputs searchWordSelectionInputs = new SearchWordSelectionInputs();
        this.kanaSearchFilterStringSelection.loadInputs(searchWordSelectionInputs);
        this.kanjiSearchFilterStringSelection.loadInputs(searchWordSelectionInputs);
        this.romajiSearchFilterStringSelection.loadInputs(searchWordSelectionInputs);
        this.pronunciationSearchFilterStringSelection.loadInputs(searchWordSelectionInputs);
        this.translationSearchFilterStringSelection.loadInputs(searchWordSelectionInputs);
        this.commentSearchFilterStringSelection.loadInputs(searchWordSelectionInputs);
        this.searchWordSearchFilterStringSelection.loadInputs(searchWordSelectionInputs);
        this.partOfSpeechSearchFilterStringSelection.loadInputs(searchWordSelectionInputs);
        this.searchFilterStringSelection.loadInputs(searchWordSelectionInputs);
        this.filteringActive = true;
        this.filterVocables();
        this.requestFocusInSearchFieldLater();
    }

    private void initCheckBoxes() {
        this.comboBoxesAreActiveCheckBox.addActionListener(actionEvent -> this.comboBoxesAreActiveCheckBoxChanged());
        this.comboBoxesAreActiveCheckBox.setSelected(true);
        String string = "<html>A<br>k<br>t<br>i<br>v</html";
        string = "";
        this.comboBoxesAreActiveCheckBox.setText(string);
        this.comboBoxesAreActiveCheckBox.setHorizontalTextPosition(0);
        this.comboBoxesAreActiveCheckBox.setVerticalTextPosition(3);
    }

    private void comboBoxesAreActiveCheckBoxChanged() {
        boolean bl = this.comboBoxesAreActiveCheckBox.isSelected();
        this.categoryFilterComboBox.setEnabled(bl);
        this.subCategoryFilterComboBox.setEnabled(bl);
        this.vocabularyDescriptionFilterComboBox.setEnabled(bl);
        this.searchWordFilterComboBox.setEnabled(bl);
        this.partsOfSpeechFilterComboBox.setEnabled(bl);
        this.filterVocables();
    }

    public void arrangeForListEditDialog() {
        this.panel.setLayout(new BorderLayout());
        this.panel.add(this.createSearchFilterSelectionsArrangedForListEditDialog(), "Center");
        this.panel.add(this.createCheckBoxComboboxesAndButtonArrangedForListEditDialog(), "South");
    }

    private Component createSearchFilterSelectionsArrangedForListEditDialog() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 3, 2, 2));
        jPanel.add(this.kanaSearchFilterStringSelection.getPanel());
        jPanel.add(this.kanjiSearchFilterStringSelection.getPanel());
        jPanel.add(this.romajiSearchFilterStringSelection.getPanel());
        jPanel.add(this.pronunciationSearchFilterStringSelection.getPanel());
        jPanel.add(this.translationSearchFilterStringSelection.getPanel());
        jPanel.add(this.commentSearchFilterStringSelection.getPanel());
        jPanel.add(this.searchWordSearchFilterStringSelection.getPanel());
        jPanel.add(this.partOfSpeechSearchFilterStringSelection.getPanel());
        jPanel.add(this.searchFilterStringSelection.getPanel());
        return jPanel;
    }

    private Component createCheckBoxComboboxesAndButtonArrangedForListEditDialog() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.comboBoxesAreActiveCheckBox, "West");
        jPanel.add(this.createComboboxesAndButtonArrangedForListEditDialog(), "Center");
        return jPanel;
    }

    private Component createComboboxesAndButtonArrangedForListEditDialog() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 3, 2, 2));
        jPanel.add(this.categoryFilterComboBox);
        jPanel.add(this.searchWordFilterComboBox);
        jPanel.add(this.vocabularyDescriptionFilterComboBox);
        jPanel.add(this.subCategoryFilterComboBox);
        jPanel.add(this.partsOfSpeechFilterComboBox);
        jPanel.add(this.createButtonPartForListEditDialog());
        return jPanel;
    }

    private Component createButtonPartForListEditDialog() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 2, 1, 1));
        jPanel.add(this.resetButton);
        jPanel.add(this.searchButton);
        return jPanel;
    }

    public void arrangeForComplexVocableSearchDialog() {
        this.panel.setLayout(new VerticalLayout(3, 3));
        this.panel.add(this.categoryFilterComboBox);
        this.panel.add(this.subCategoryFilterComboBox);
        this.panel.add(this.vocabularyDescriptionFilterComboBox);
        this.panel.add(this.searchWordFilterComboBox);
        this.panel.add(this.partsOfSpeechFilterComboBox);
        this.panel.add(this.createVocableSearchFilterPartForComplexVocableSearchDialog());
    }

    private Component createVocableSearchFilterPartForComplexVocableSearchDialog() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createSearchFilterSelectionsPart(), "Center");
        jPanel.add(this.createButtonPart(), "South");
        return jPanel;
    }

    private Component createButtonPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(2, 3));
        jPanel.add(this.resetButton);
        jPanel.add(this.searchButton);
        return jPanel;
    }

    private Component createSearchFilterSelectionsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(3, 3));
        jPanel.add(this.kanaSearchFilterStringSelection.getPanel());
        jPanel.add(this.kanjiSearchFilterStringSelection.getPanel());
        jPanel.add(this.romajiSearchFilterStringSelection.getPanel());
        jPanel.add(this.pronunciationSearchFilterStringSelection.getPanel());
        jPanel.add(this.translationSearchFilterStringSelection.getPanel());
        jPanel.add(this.commentSearchFilterStringSelection.getPanel());
        jPanel.add(this.searchWordSearchFilterStringSelection.getPanel());
        jPanel.add(this.partOfSpeechSearchFilterStringSelection.getPanel());
        jPanel.add(this.searchFilterStringSelection.getPanel());
        return jPanel;
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public void requestFocusInSearchFieldLater() {
        SwingUtilities.invokeLater(() -> this.searchFilterStringSelection.requestFocus());
    }

    public void loadInputs(VocableFilterInputs vocableFilterInputs) {
        this.filteringActive = false;
        this.categoryFilterComboBox.setSelectedIndex(vocableFilterInputs.getCategoryFilterComboBoxIndex());
        this.subCategoryFilterComboBox.setSelectedIndex(vocableFilterInputs.getSubCategoryFilterComboBoxIndex());
        this.vocabularyDescriptionFilterComboBox.setSelectedIndex(vocableFilterInputs.getVocabularyDescriptionFilterComboBoxIndex());
        this.searchWordFilterComboBox.setSelectedIndex(vocableFilterInputs.getSearchWordFilterComboBoxIndex());
        this.partsOfSpeechFilterComboBox.setSelectedIndex(vocableFilterInputs.getPartsOfSpeechFilterComboBoxIndex());
        this.kanaSearchFilterStringSelection.loadInputs(vocableFilterInputs.getKanaSearchFilterInputs());
        this.kanjiSearchFilterStringSelection.loadInputs(vocableFilterInputs.getKanjiSearchFilterInputs());
        this.romajiSearchFilterStringSelection.loadInputs(vocableFilterInputs.getRomajiSearchFilterInputs());
        this.pronunciationSearchFilterStringSelection.loadInputs(vocableFilterInputs.getPronunciationSearchFilterInputs());
        this.translationSearchFilterStringSelection.loadInputs(vocableFilterInputs.getTranslationSearchFilterInputs());
        this.commentSearchFilterStringSelection.loadInputs(vocableFilterInputs.getCommentSearchFilterInputs());
        this.searchWordSearchFilterStringSelection.loadInputs(vocableFilterInputs.getSearchWordSearchFilterInputs());
        this.partOfSpeechSearchFilterStringSelection.loadInputs(vocableFilterInputs.getPartOfSpeechSearchFilterInputs());
        this.searchFilterStringSelection.loadInputs(vocableFilterInputs.getSearchFilterInputs());
        this.filteringActive = true;
        this.searchButton.doClick();
    }

    public void storeInputs(VocableFilterInputs vocableFilterInputs) {
        vocableFilterInputs.setCategoryFilterComboBoxIndex(this.categoryFilterComboBox.getSelectedIndex());
        vocableFilterInputs.setSubCategoryFilterComboBoxIndex(this.subCategoryFilterComboBox.getSelectedIndex());
        vocableFilterInputs.setVocabularyDescriptionFilterComboBoxIndex(this.vocabularyDescriptionFilterComboBox.getSelectedIndex());
        vocableFilterInputs.setSearchWordFilterComboBoxIndex(this.searchWordFilterComboBox.getSelectedIndex());
        vocableFilterInputs.setPartsOfSpeechFilterComboBoxIndex(this.partsOfSpeechFilterComboBox.getSelectedIndex());
        this.kanaSearchFilterStringSelection.storeInputs(vocableFilterInputs.getKanaSearchFilterInputs());
        this.kanjiSearchFilterStringSelection.storeInputs(vocableFilterInputs.getKanjiSearchFilterInputs());
        this.romajiSearchFilterStringSelection.storeInputs(vocableFilterInputs.getRomajiSearchFilterInputs());
        this.pronunciationSearchFilterStringSelection.storeInputs(vocableFilterInputs.getPronunciationSearchFilterInputs());
        this.translationSearchFilterStringSelection.storeInputs(vocableFilterInputs.getTranslationSearchFilterInputs());
        this.commentSearchFilterStringSelection.storeInputs(vocableFilterInputs.getCommentSearchFilterInputs());
        this.searchWordSearchFilterStringSelection.storeInputs(vocableFilterInputs.getSearchWordSearchFilterInputs());
        this.partOfSpeechSearchFilterStringSelection.storeInputs(vocableFilterInputs.getPartOfSpeechSearchFilterInputs());
        this.searchFilterStringSelection.storeInputs(vocableFilterInputs.getSearchFilterInputs());
    }
}

