/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.listcommander.list.element;

import de.duehl.basics.text.Text;
import de.duehl.basics.text.html.HtmlTool;
import de.duehl.swing.ui.GuiTools;
import de.duehl.twosidecommander.ui.color.ListCommanderColors;
import de.duehl.twosidecommander.ui.list.data.ListElementMoveReactor;
import de.duehl.twosidecommander.ui.list.element.ListElementDisplayer;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.ui.listcommander.OwnListCommander;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JLabel;

public class OwnListElementDisplayer
extends ListElementDisplayer {
    private final OwnListCommander commander;
    private final Vocable vocable;
    private JLabel label;
    private static final int MAX_TEXT_LENGTH = 80;

    public OwnListElementDisplayer(ListElementMoveReactor listElementMoveReactor, OwnListCommander ownListCommander, Vocable vocable) {
        super(listElementMoveReactor);
        this.commander = ownListCommander;
        this.vocable = vocable;
        this.setListElementShowDetailsName("Details der Vokabel anzeigen ...");
        this.initLabel();
        this.createGui();
    }

    private void initLabel() {
        Object object = " " + this.vocable.getTranslations().get(0) + " - " + this.vocable.getKanjiKanaRomajiWithJapaneseBraces() + " ";
        if (((String)object).length() > 80) {
            object = ((String)object).substring(0, 80) + " ...";
        }
        object = Text.addLineBreaks((String)object, 60, 10);
        object = HtmlTool.htmlify((String)object);
        this.label = new JLabel((String)object);
        GuiTools.biggerFont(this.label, 3);
        this.label.setOpaque(true);
        this.label.setBackground(Color.WHITE);
        this.label.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.label.setPreferredSize(new Dimension(1, 40));
    }

    @Override
    protected final void reactOnShowDetailsClickInRightClickMenu() {
        this.commander.showVocableDetails(this.vocable);
    }

    @Override
    protected Component createElementDisplay() {
        return this.label;
    }

    @Override
    public void showSelectedAndHighlighted() {
        this.label.setForeground(ListCommanderColors.SELECTED_LABEL_FOREGROUND_COLOR);
        this.label.setBackground(ListCommanderColors.HIGHLIGHTED_LABEL_BACKGROUND_COLOR);
    }

    @Override
    public final void showSelected() {
        this.label.setForeground(ListCommanderColors.SELECTED_LABEL_FOREGROUND_COLOR);
        this.label.setBackground(ListCommanderColors.NORMAL_LABEL_BACKGROUND_COLOR);
    }

    @Override
    public final void showHighlighted() {
        this.label.setForeground(ListCommanderColors.NORMAL_LABEL_FOREGROUND_COLOR);
        this.label.setBackground(ListCommanderColors.HIGHLIGHTED_LABEL_BACKGROUND_COLOR);
    }

    @Override
    public final void showNormal() {
        this.label.setForeground(ListCommanderColors.NORMAL_LABEL_FOREGROUND_COLOR);
        this.label.setBackground(ListCommanderColors.NORMAL_LABEL_BACKGROUND_COLOR);
    }

    public String toString() {
        return "OwnListElementDisplayer [" + this.vocable.getKanjiKanaRomajiWithJapaneseBraces() + "]";
    }

    @Override
    public String getElementDescription() {
        return this.vocable.getTranslations().get(0) + " - " + this.vocable.getKanjiKanaRomajiWithJapaneseBraces();
    }

    public Vocable getVocable() {
        return this.vocable;
    }

    public static final OwnListElementDisplayer castListElementDisplayer(ListElementDisplayer listElementDisplayer) {
        return (OwnListElementDisplayer)listElementDisplayer;
    }
}

