/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.tabs;

import de.duehl.swing.ui.GuiTools;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.data.FumikoDataStructures;
import de.duehl.vocabulary.japanese.data.OwnList;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.data.Vocabulary;
import de.duehl.vocabulary.japanese.logic.VocabularyTrainerLogic;
import de.duehl.vocabulary.japanese.logic.ownlists.OwnLists;
import de.duehl.vocabulary.japanese.tools.VocabularyTools;
import de.duehl.vocabulary.japanese.ui.VocabularyTrainerGui;
import de.duehl.vocabulary.japanese.ui.components.bars.VocabularyBar;
import de.duehl.vocabulary.japanese.ui.data.FumikoUiObjects;
import de.duehl.vocabulary.japanese.ui.tabs.CategoryTabs;
import de.duehl.vocabulary.japanese.ui.tabs.WrongTestedVocablesUi;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class MainTabs {
    private final VocabularyTrainerLogic logic;
    private final VocabularyTrainerGui gui;
    private final FumikoUiObjects uiObjects;
    private final JTabbedPane mainTabs;
    private final JPanel vocabulariesTabPanel;
    private final JPanel ownListsTabPanel;
    private final JPanel wrongTestedVocablesTabPanel;
    private CategoryTabs vocabularyCategoryTabs;
    private CategoryTabs ownListCategoryTabs;
    private WrongTestedVocablesUi wrongTestedVocablesUi;
    private FumikoDataStructures dataStructures;
    static final String VOCABULARY_LAST_SHOWN_TAB_INDEX_TYPE = "Vocabulary";
    static final String OWN_LIST_LAST_SHOWN_TAB_INDEX_TYPE = "OwnList";

    public MainTabs(VocabularyTrainerLogic vocabularyTrainerLogic, VocabularyTrainerGui vocabularyTrainerGui, FumikoUiObjects fumikoUiObjects) {
        this.logic = vocabularyTrainerLogic;
        this.gui = vocabularyTrainerGui;
        this.uiObjects = fumikoUiObjects;
        this.mainTabs = new JTabbedPane();
        this.vocabulariesTabPanel = new JPanel();
        this.ownListsTabPanel = new JPanel();
        this.wrongTestedVocablesTabPanel = new JPanel();
        this.init();
    }

    private void init() {
        this.initMainTabs();
        this.initTabPanels();
    }

    private void initMainTabs() {
        this.mainTabs.add("vorgegebene Vokabularien", GuiTools.createScrollPane(this.vocabulariesTabPanel));
        this.mainTabs.add("eigene Vokabellisten", GuiTools.createScrollPane(this.ownListsTabPanel));
        this.mainTabs.add("falsch \u00fcbersetzte Vokabeln", GuiTools.createScrollPane(this.wrongTestedVocablesTabPanel));
    }

    private void initTabPanels() {
        this.vocabulariesTabPanel.setLayout(new BorderLayout());
        this.ownListsTabPanel.setLayout(new BorderLayout());
        this.wrongTestedVocablesTabPanel.setLayout(new BorderLayout());
    }

    public void initWithDataStructures(FumikoDataStructures fumikoDataStructures) {
        this.dataStructures = fumikoDataStructures;
        this.initWithDataStructures();
    }

    private void initWithDataStructures() {
        this.createVocabularyTabFromScratch();
        this.createOwnListsTabFromScratch();
        this.createWrongTestedVocablesTabFromScratch();
        this.showTabsWeViewedLastTime();
    }

    private void createVocabularyTabFromScratch() {
        List<Vocabulary> list = this.dataStructures.getVocabularies();
        List<String> list2 = VocabularyTools.determineCategories(list);
        this.vocabulariesTabPanel.removeAll();
        this.vocabularyCategoryTabs = new CategoryTabs(list2, list, this.logic, this.gui, this.dataStructures, this.uiObjects);
        this.vocabulariesTabPanel.add((Component)this.vocabularyCategoryTabs.getCategoryTabs(), "Center");
    }

    public void createOwnListsTabFromScratch() {
        OwnLists ownLists = this.dataStructures.getOwnLists();
        List<String> list = VocabularyTools.determineCategories(ownLists.getOwnLists());
        this.ownListsTabPanel.removeAll();
        this.ownListCategoryTabs = new CategoryTabs(list, ownLists.getOwnLists(), this.logic, this.gui, this.dataStructures, this.uiObjects);
        this.ownListsTabPanel.add((Component)this.ownListCategoryTabs.getCategoryTabs(), "Center");
    }

    private void createWrongTestedVocablesTabFromScratch() {
        this.wrongTestedVocablesTabPanel.removeAll();
        this.wrongTestedVocablesUi = new WrongTestedVocablesUi(this.logic, this.gui, this.dataStructures, this.uiObjects);
        this.wrongTestedVocablesTabPanel.add((Component)this.wrongTestedVocablesUi.getPanel(), "Center");
    }

    public void showTabsWeViewedLastTime() {
        Options options = this.dataStructures.getOptions();
        int n = options.getLastShownMainTabIndex();
        if (n >= 0 && n < this.mainTabs.getTabCount()) {
            this.mainTabs.setSelectedIndex(n);
        }
        this.vocabularyCategoryTabs.showTabsWeViewedLastTime(VOCABULARY_LAST_SHOWN_TAB_INDEX_TYPE);
        this.ownListCategoryTabs.showTabsWeViewedLastTime(OWN_LIST_LAST_SHOWN_TAB_INDEX_TYPE);
    }

    public void storeShownTabIndices(Options options) {
        if (null != this.vocabularyCategoryTabs) {
            int n = this.mainTabs.getSelectedIndex();
            options.setLastShownMainTabIndex(n);
            this.vocabularyCategoryTabs.storeShownTabIndices(options, VOCABULARY_LAST_SHOWN_TAB_INDEX_TYPE);
            this.ownListCategoryTabs.storeShownTabIndices(options, OWN_LIST_LAST_SHOWN_TAB_INDEX_TYPE);
        }
    }

    public List<Vocable> collectVocablesOfSelectedVocabularies() {
        ArrayList<Vocable> arrayList = new ArrayList<Vocable>();
        arrayList.addAll(this.vocabularyCategoryTabs.collectVocablesOfSelectedVocabularies());
        arrayList.addAll(this.ownListCategoryTabs.collectVocablesOfSelectedVocabularies());
        return arrayList;
    }

    public void showVocabularyBarsInWantedOrder() {
        this.vocabularyCategoryTabs.showVocabularyBarsInWantedOrder();
        this.ownListCategoryTabs.showVocabularyBarsInWantedOrder();
    }

    public void showOrHideIndividualVocabularySortModeMoveButtons() {
        this.vocabularyCategoryTabs.showOrHideIndividualVocabularySortModeMoveButtons();
        this.ownListCategoryTabs.showOrHideIndividualVocabularySortModeMoveButtons();
    }

    public List<Vocabulary> getVocabulariesInIndividualOrder() {
        if (null == this.vocabularyCategoryTabs) {
            return new ArrayList<Vocabulary>();
        }
        return this.vocabularyCategoryTabs.getVocabulariesInIndividualOrder();
    }

    public List<OwnList> getOwnListsInIndividualOrder() {
        if (null == this.ownListCategoryTabs) {
            return new ArrayList<OwnList>();
        }
        return this.ownListCategoryTabs.getOwnListsInIndividualOrder();
    }

    public List<VocabularyBar> determineBarsOfSelectedTab() {
        int n = this.mainTabs.getSelectedIndex();
        if (n == 0) {
            return this.vocabularyCategoryTabs.determineBarsOfSelectedTab();
        }
        if (n == 1) {
            return this.ownListCategoryTabs.determineBarsOfSelectedTab();
        }
        if (n == 2) {
            return this.wrongTestedVocablesUi.getVocabularyBars();
        }
        throw new RuntimeException("Unbekannter Tab Index " + n);
    }

    public void setCorrectForegroundColorOfVocabularyBars() {
        this.vocabularyCategoryTabs.setCorrectForegroundColorOfVocabularyBars();
        this.ownListCategoryTabs.setCorrectForegroundColorOfVocabularyBars();
        for (VocabularyBar vocabularyBar : this.wrongTestedVocablesUi.getVocabularyBars()) {
            vocabularyBar.setCorrectForegroundColor();
        }
    }

    public void setCorrectTextOfVocabularyBars() {
        this.vocabularyCategoryTabs.setCorrectTextOfVocabularyBars();
        this.ownListCategoryTabs.setCorrectTextOfVocabularyBars();
        for (VocabularyBar vocabularyBar : this.wrongTestedVocablesUi.getVocabularyBars()) {
            vocabularyBar.setCorrectText();
        }
    }

    public void showOrHidePercentInVocabularyBarsLater() {
        this.vocabularyCategoryTabs.showOrHidePercentInVocabularyBarsLater();
        this.ownListCategoryTabs.showOrHidePercentInVocabularyBarsLater();
    }

    public Component getPanel() {
        return this.mainTabs;
    }

    public void showTranslationDirectionOnBarButtons() {
        this.vocabularyCategoryTabs.showTranslationDirectionOnBarButtons();
        this.ownListCategoryTabs.showTranslationDirectionOnBarButtons();
        for (VocabularyBar vocabularyBar : this.wrongTestedVocablesUi.getVocabularyBars()) {
            vocabularyBar.showTranslationDirectionOnBarButtons();
        }
    }

    public void toggleShowOwnListButtons() {
        this.vocabularyCategoryTabs.showTestViewListSheetButtons();
        this.ownListCategoryTabs.toggleShowOwnListButtons();
    }

    public void showTestViewListSheetButtons() {
        this.vocabularyCategoryTabs.showTestViewListSheetButtons();
        this.ownListCategoryTabs.showTestViewListSheetButtons();
    }

    public void showOwnListExtraButtons() {
        this.ownListCategoryTabs.showOwnListExtraButtons();
    }

    public void showTabWithOwnLists() {
        this.mainTabs.setSelectedIndex(1);
    }
}

