/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.tabs;

import de.duehl.swing.ui.components.MultipleElementsPanel;
import de.duehl.swing.ui.move.data.MovingGui;
import de.duehl.vocabulary.japanese.common.data.VocabularySortOrder;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.data.FumikoDataStructures;
import de.duehl.vocabulary.japanese.data.OwnList;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.data.Vocabulary;
import de.duehl.vocabulary.japanese.logic.VocabularyTrainerLogic;
import de.duehl.vocabulary.japanese.ui.VocabularyTrainerGui;
import de.duehl.vocabulary.japanese.ui.components.bars.VocabularyBar;
import de.duehl.vocabulary.japanese.ui.data.FumikoUiObjects;
import de.duehl.vocabulary.japanese.ui.sort.VocabularyBarSorter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;

public class VocabularyPanel
implements MovingGui<VocabularyBar> {
    private final VocabularyTrainerGui gui;
    private final FumikoDataStructures dataStructures;
    private final JPanel vocabularyPanel;
    private List<VocabularyBar> vocabularyBars;

    public VocabularyPanel(List<Vocabulary> list, VocabularyTrainerLogic vocabularyTrainerLogic, VocabularyTrainerGui vocabularyTrainerGui, FumikoDataStructures fumikoDataStructures, FumikoUiObjects fumikoUiObjects) {
        this.gui = vocabularyTrainerGui;
        this.dataStructures = fumikoDataStructures;
        this.vocabularyPanel = new JPanel();
        this.vocabularyBars = new ArrayList<VocabularyBar>();
        for (Vocabulary vocabulary : list) {
            VocabularyBar vocabularyBar = new VocabularyBar(vocabulary, vocabularyTrainerLogic, vocabularyTrainerGui, fumikoDataStructures, fumikoUiObjects, this);
            this.vocabularyBars.add(vocabularyBar);
        }
        this.init();
        this.populateVocabularyPanel();
    }

    private void init() {
        this.vocabularyPanel.setLayout(new BorderLayout());
    }

    private void populateVocabularyPanel() {
        this.vocabularyPanel.removeAll();
        Options options = this.dataStructures.getOptions();
        int n = options.getNumberOfVocabularyBarColumns();
        ArrayList<Component> arrayList = new ArrayList<Component>();
        for (VocabularyBar object : this.vocabularyBars) {
            Component component = object.getPanel();
            arrayList.add(component);
        }
        MultipleElementsPanel multipleElementsPanel = new MultipleElementsPanel(arrayList, n, 5);
        for (VocabularyBar vocabularyBar : this.vocabularyBars) {
            vocabularyBar.setUpAndDownButtonColorsAndEnabled();
        }
        this.vocabularyPanel.add((Component)multipleElementsPanel, "Center");
    }

    @Override
    public boolean canBarMoveUp(VocabularyBar vocabularyBar) {
        List<VocabularyBar> list = this.determineBarsOfCategory(vocabularyBar.getVocabularyCategory());
        return list.contains(vocabularyBar) && vocabularyBar != list.get(0);
    }

    @Override
    public boolean canBarMoveDown(VocabularyBar vocabularyBar) {
        List<VocabularyBar> list = this.determineBarsOfCategory(vocabularyBar.getVocabularyCategory());
        return list.contains(vocabularyBar) && vocabularyBar != list.get(list.size() - 1);
    }

    @Override
    public void moveBarToFirst(VocabularyBar vocabularyBar) {
        List<VocabularyBar> list = this.determineBarsOfCategory(vocabularyBar.getVocabularyCategory());
        VocabularyBar vocabularyBar2 = list.get(0);
        int n = this.vocabularyBars.indexOf(vocabularyBar2);
        int n2 = this.vocabularyBars.indexOf(vocabularyBar);
        this.vocabularyBars.remove(n2);
        this.vocabularyBars.add(n, vocabularyBar);
        this.populateVocabularyPanel();
        this.gui.saveManualVocabularyOrder();
    }

    @Override
    public void moveBarUp(VocabularyBar vocabularyBar) {
        List<VocabularyBar> list = this.determineBarsOfCategory(vocabularyBar.getVocabularyCategory());
        int n = list.indexOf(vocabularyBar);
        VocabularyBar vocabularyBar2 = list.get(n - 1);
        int n2 = this.vocabularyBars.indexOf(vocabularyBar2);
        int n3 = this.vocabularyBars.indexOf(vocabularyBar);
        this.vocabularyBars.remove(n3);
        this.vocabularyBars.add(n2, vocabularyBar);
        this.populateVocabularyPanel();
        this.gui.saveManualVocabularyOrder();
    }

    @Override
    public void moveBarDown(VocabularyBar vocabularyBar) {
        List<VocabularyBar> list = this.determineBarsOfCategory(vocabularyBar.getVocabularyCategory());
        int n = list.indexOf(vocabularyBar);
        VocabularyBar vocabularyBar2 = list.get(n + 1);
        int n2 = this.vocabularyBars.indexOf(vocabularyBar2);
        int n3 = this.vocabularyBars.indexOf(vocabularyBar);
        this.vocabularyBars.remove(n3);
        this.vocabularyBars.add(n2, vocabularyBar);
        this.populateVocabularyPanel();
        this.gui.saveManualVocabularyOrder();
    }

    @Override
    public void moveBarToLast(VocabularyBar vocabularyBar) {
        List<VocabularyBar> list = this.determineBarsOfCategory(vocabularyBar.getVocabularyCategory());
        VocabularyBar vocabularyBar2 = list.get(list.size() - 1);
        int n = this.vocabularyBars.indexOf(vocabularyBar2);
        int n2 = this.vocabularyBars.indexOf(vocabularyBar);
        this.vocabularyBars.remove(n2);
        this.vocabularyBars.add(n, vocabularyBar);
        this.populateVocabularyPanel();
        this.gui.saveManualVocabularyOrder();
    }

    public List<VocabularyBar> getBars() {
        ArrayList<VocabularyBar> arrayList = new ArrayList<VocabularyBar>();
        for (VocabularyBar vocabularyBar : this.vocabularyBars) {
            arrayList.add(vocabularyBar);
        }
        return arrayList;
    }

    private List<VocabularyBar> determineBarsOfCategory(String string) {
        ArrayList<VocabularyBar> arrayList = new ArrayList<VocabularyBar>();
        for (VocabularyBar vocabularyBar : this.vocabularyBars) {
            String string2 = vocabularyBar.getVocabularyCategory();
            if (!string.equals(string2)) continue;
            arrayList.add(vocabularyBar);
        }
        return arrayList;
    }

    public void setCorrectForegroundColorOfVocabularyBars() {
        for (VocabularyBar vocabularyBar : this.vocabularyBars) {
            vocabularyBar.setCorrectForegroundColor();
        }
    }

    public void setCorrectTextOfVocabularyBars() {
        for (VocabularyBar vocabularyBar : this.vocabularyBars) {
            vocabularyBar.setCorrectText();
        }
    }

    public void showOrHidePercentInVocabularyBars() {
        for (VocabularyBar vocabularyBar : this.vocabularyBars) {
            vocabularyBar.showOrHidePercent();
        }
    }

    public void showOrHideIndividualVocabularySortModeMoveButtons() {
        for (VocabularyBar vocabularyBar : this.vocabularyBars) {
            vocabularyBar.showOrHideIndividualVocabularySortModeMoveButtons();
        }
    }

    public List<Vocabulary> getVocabularyBarsInIndividualOrder() {
        ArrayList<Vocabulary> arrayList = new ArrayList<Vocabulary>();
        for (VocabularyBar vocabularyBar : this.vocabularyBars) {
            arrayList.add(vocabularyBar.getVocabulary());
        }
        return arrayList;
    }

    public List<OwnList> getOwnListsInIndividualOrder() {
        ArrayList<OwnList> arrayList = new ArrayList<OwnList>();
        for (VocabularyBar vocabularyBar : this.vocabularyBars) {
            arrayList.add(vocabularyBar.getVocabularyAsOwnList());
        }
        return arrayList;
    }

    public List<Vocable> collectVocablesOfSelectedVocabularies() {
        ArrayList<Vocable> arrayList = new ArrayList<Vocable>();
        for (VocabularyBar vocabularyBar : this.vocabularyBars) {
            if (!vocabularyBar.isSelected()) continue;
            Vocabulary vocabulary = vocabularyBar.getVocabulary();
            arrayList.addAll(vocabulary.getVocables());
        }
        return arrayList;
    }

    public void showVocabularyBarsInWantedOrder() {
        Options options = this.dataStructures.getOptions();
        VocabularySortOrder vocabularySortOrder = options.getVocabularySortOrder();
        VocabularyBarSorter vocabularyBarSorter = new VocabularyBarSorter(this.vocabularyBars, vocabularySortOrder);
        vocabularyBarSorter.sort();
        this.populateVocabularyPanel();
    }

    public JPanel getVocabularyPanel() {
        return this.vocabularyPanel;
    }

    public void showTranslationDirectionOnBarButtons() {
        for (VocabularyBar vocabularyBar : this.vocabularyBars) {
            vocabularyBar.showTranslationDirectionOnBarButtons();
        }
    }

    public void toggleShowOwnListButtons() {
        for (VocabularyBar vocabularyBar : this.vocabularyBars) {
            vocabularyBar.toggleShowOwnListButtons();
        }
    }

    public void showTestViewListSheetButtons() {
        for (VocabularyBar vocabularyBar : this.vocabularyBars) {
            vocabularyBar.showTestViewListSheetButtons();
        }
    }

    public void showOwnListExtraButtons() {
        for (VocabularyBar vocabularyBar : this.vocabularyBars) {
            vocabularyBar.showOwnListExtraButtons();
        }
    }
}

