/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.website.update.ownlists.parser;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.text.NumberString;
import de.duehl.basics.text.Text;
import de.duehl.basics.text.handling.BooleanHandling;
import de.duehl.vocabulary.japanese.website.update.ownlists.data.OwnListInterestAndVersionEntry;
import java.util.ArrayList;
import java.util.List;

public class OwnListVersionAndInterestParser {
    private final String content;
    private List<String> lines;
    private boolean success;
    private String failReason;
    private List<OwnListInterestAndVersionEntry> ownListInterestAndVersionEntries;

    public OwnListVersionAndInterestParser(String string) {
        this.content = string;
    }

    public void parse() {
        this.init();
        this.splitContent();
        this.parseLines();
        this.removeAllEntriesIfErrorOccured();
    }

    private void init() {
        this.success = true;
        this.failReason = "";
        this.ownListInterestAndVersionEntries = new ArrayList<OwnListInterestAndVersionEntry>();
    }

    private void splitContent() {
        this.lines = Text.splitByLineBreaks(this.content);
        CollectionsHelper.removeEmptyAndOnlyWhitespaceStringsFromList(this.lines);
    }

    private void parseLines() {
        for (String string : this.lines) {
            OwnListInterestAndVersionEntry ownListInterestAndVersionEntry = this.parseLine(string);
            this.ownListInterestAndVersionEntries.add(ownListInterestAndVersionEntry);
        }
    }

    private OwnListInterestAndVersionEntry parseLine(String string) {
        try {
            return this.tryToParseLine(string);
        }
        catch (Exception exception) {
            this.fail("Die Zeile '" + string + "' l\u00e4sst sich nicht parsen: " + exception.getMessage());
            return new OwnListInterestAndVersionEntry("", false, -1);
        }
    }

    private OwnListInterestAndVersionEntry tryToParseLine(String string) {
        List<String> list = Text.splitBySubtraction(string);
        if (list.size() != 3) {
            throw new RuntimeException("Die Zeile l\u00e4sst sich nicht an '-' in drei Teile teilen.");
        }
        String string2 = list.get(0);
        String string3 = list.get(1);
        String string4 = list.get(2);
        boolean bl = BooleanHandling.stringToBoolean(string3);
        if (!NumberString.isDigitSequence(string4)) {
            throw new RuntimeException("Die Version '" + string4 + "' in der Zeile besteht nicht nur aus Ziffern");
        }
        int n = NumberString.parseInt(string4);
        return new OwnListInterestAndVersionEntry(string2, bl, n);
    }

    private void removeAllEntriesIfErrorOccured() {
        if (!this.success) {
            this.ownListInterestAndVersionEntries.clear();
        }
    }

    private void fail(String string) {
        this.success = false;
        this.failReason = string;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getFailReason() {
        return this.failReason;
    }

    public List<OwnListInterestAndVersionEntry> getOwnListInterestAndVersionEntries() {
        return this.ownListInterestAndVersionEntries;
    }
}

