package de.duehl.basics.autodetect.ent.single;

/*
 * Copyright 2022 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import de.duehl.basics.text.data.FoundSearch;

/**
 * Dieses Interface steht für eine  Klasse, die einen Begriff in 'ent' finden kann.
 *
 * @version 1.01     2022-05-05
 * @author Christian Dühl
 */

public interface DetectSingleThingFinder {

    /**
     * Findet einen Begriff in 'ent' und liefert ihn als Fundstelle zurück, ohne 'ent' zu
     * verändern.
     */
    FoundSearch findThing(String ent);

}
