package de.duehl.basics.datetime.date.parse;

/*
 * Copyright 2018 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.util.regex.Pattern;

import de.duehl.basics.datetime.date.ImmutualDate;

/**
 * Diese Klasse stellt die Methode zum Parsen des Standardfalls eines Datums aus einem String
 * dar.
 *
 * Erkannt werden:
 *     - 11.02.1967
 *     - 11. 02.    1967
 *     - 11.2.1967
 *     - 1.1.2018
 *
 * @version 1.01     2018-11-16
 * @author Christian Dühl
 */

public class DateParseMethodNormal extends DateParseMethod {

    private final static Pattern PATTERN = Pattern.compile(
            "(\\d{1,2})\\.\\s*(\\d{1,2})\\.\\s*(\\d{4})");

    public DateParseMethodNormal(String dateToParse) {
        super(dateToParse, PATTERN);
    }

    @Override
    protected ImmutualDate createDateFromMatcher() {
        int day   = Integer.parseInt(matcher.group(1));
        int month = Integer.parseInt(matcher.group(2));
        int year  = Integer.parseInt(matcher.group(3));

        return new ImmutualDate(day, month, year);
    }

}
