package de.duehl.basics.datetime.time.watch;

/*
 * Copyright 2021 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.io.Serializable;

import de.duehl.basics.datetime.DateAndTime;
import de.duehl.basics.datetime.time.ImmutualTime;
import de.duehl.basics.datetime.time.TimeHelper;

/**
 * Eine Klasse zur Zeitmessung.
 *
 * @version 1.01     2021-03-17
 * @author Christian Dühl
 */

public class Watch implements WatchBase, Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * Liest die Zeit auf der Uhr ab und gib sie in einem von Menschen lesbarem Format zurück.
     *
     * @return Uhrzeit im Format HH:MM:SS.
     */
    @Override
    public String getTime() {
        DateAndTime now = new DateAndTime();
        ImmutualTime time = now.getTime();
        return time.toString();
    }

    /** Gibt die Zeit seit Mitternacht in Sekunden zurück. */
    @Override
    public long getTimeInSeconds() {
        return TimeHelper.hoursMinutesSecondsToSeconds(getTime());
    }

    /** Stringrepräsentation. */
    @Override
    public String toString() {
        return "Watch [" + getTime() + "]";
    }

}
