package de.duehl.basics.editor;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import de.duehl.basics.io.FileHelper;
import de.duehl.basics.io.exceptions.IORuntimeException;

/**
 * Diese Klasse ermittelt den passenden Editor und erlaubt es, Dateien in diesem zu öffnen.
 *
 * @version 1.01     2016-08-25
 * @author Christian Dühl
 */

public class Editor {

    /** Ausführbarer Editor mit Pfad. */
    private final String editor;

    /**
     * Konstruktor.
     *
     * @throws RuntimeException
     *             Falls kein Editor gefunden wurde.
     */
    public Editor() {
        editor = determineEditor();
    }

    /** Ausführbare Datei mit Pfad zum zu verwendenden Editor. */
    private String determineEditor() {
        List<String> candidates = new ArrayList<>();

        candidates.add("C:/CriansProgramme/Notepad++/notepad++.exe");
        candidates.add("C:/meine_programme/Notepad++/notepad++.exe");
        candidates.add("C:/Programme/Notepad++/notepad++.exe");
        candidates.add("C:/Programme (x86)/Notepad++/notepad++.exe");
        candidates.add("C:/Program Files/Notepad++/notepad++.exe");
        candidates.add("C:/Program Files (x86)/Notepad++/notepad++.exe");
        candidates.add("C:/Program Files/Vim/vim70/gvim.exe");
        candidates.add("C:/Program Files (x86)/Vim/vim70/gvim.exe");
        candidates.add("C:/Windows/System32/Notepad.exe");

        for (String editor : candidates) {
            if (FileHelper.exists(editor)) {
                return editor;
            }
        }

        throw new RuntimeException("Der Editor konnte nicht bestimmt werden!");
        /*
         * Statt dessen Pfad zur ausführbaren Datei in die Optionen stellen und vom Benutzer
         * einstellbar machen?
         *
         * Oder an dieser Stelle nachfragen?
         */
    }

    /**
     * Öffnet eine Datei in Notepad++
     *
     * @param fileName
     *            Name der Datei.
     * @throws IORuntimeException
     *             Falls es Probleme beim Öffnen des Editors gab.
     */
    public void edit(String fileName) {
        String[] params = {
                "cmd",
                "/c",
                editor,   //"C:\\CriansProgramme\\Notepad++\\notepad++.exe",
                fileName
        };
        ProcessBuilder processBuilder = new ProcessBuilder(params);
        try {
            processBuilder.start();
        }
        catch (IOException exception) {
            throw new IORuntimeException(exception);
        }
    }

}
