package de.duehl.basics.io.exceptions;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.io.FileNotFoundException;

/**
 * Ausnahmeklasse, die statt einer FileNotFoundException eine
 * FileNotFoundRuntimeException darstellt.
 *
 * @version 1.01     2013-12-12
 * @author Christian Dühl
 */

public class FileNotFoundRuntimeException extends RuntimeException {

    private static final long serialVersionUID = 2795730444012714039L;

    /** Konstruktor */
    public FileNotFoundRuntimeException() {
        super();
    }

    /**
     * Konstruktor
     *
     * @param message
     *            Text der Fehlermeldung.
     */
    public FileNotFoundRuntimeException(String message) {
        super(message);
    }

    /**
     * Konstruktor
     *
     * @param exception
     *            Die FileNotFoundException, die nun in Form einer
     *            RuntimeException verpackt werden soll.
     */
    public FileNotFoundRuntimeException(FileNotFoundException exception) {
        super(exception);
    }

}