package de.duehl.basics.io.exceptions;

/*
 * Copyright 2021 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.io.IOException;

/**
 * Ausnahmeklasse, die statt einer IOException eine IORumtimeException darstellt.
 *
 * @version 1.01     2021-05-27
 * @author Christian Dühl
 */

public class IORuntimeException extends RuntimeException {

    private static final long serialVersionUID = -6764112503071198492L;

    /** Konstruktor */
    public IORuntimeException() {
        super();
    }

    /**
     * Konstruktor
     *
     * @param message
     *            Text der Fehlermeldung.
     */
    public IORuntimeException(String message) {
        super(message);
    }

    /**
     * Konstruktor
     *
     * @param exception
     *            Die IOException, die nun in Form einer RuntimeException verpackt werden soll.
     */
    public IORuntimeException(IOException exception) {
        super(exception);
    }

    /**
     * Konstruktor
     *
     * @param message
     *            Text der Fehlermeldung.
     * @param exception
     *            Die InterruptedException, die nun in Form einer RuntimeException verpackt werden
     *            soll.
     */
    public IORuntimeException(String message, InterruptedException exception) {
        super(message, exception);
    }

    /**
     * Konstruktor
     *
     * @param message
     *            Text der Fehlermeldung.
     * @param exception
     *            Die IOException, die nun in Form einer RuntimeException verpackt werden soll.
     */
    public IORuntimeException(String message, IOException exception) {
        super(message, exception);
    }

}