package de.duehl.basics.io.exceptions;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

/**
 * Ausnahmeklasse, die für ein Fehler beim Erstellen oder Entpacken einer Zip-Datei auftritt.
 *
 * @version 1.01     2016-01-27
 * @author Christian Dühl
 */

public class ZippingException extends RuntimeException {

    private static final long serialVersionUID = 853604194153431573L;

    /**
     * Konstruktor
     *
     * @param message
     *            Text der Fehlermeldung.
     */
    public ZippingException(String message) {
        super(message);
    }

    /**
     * Konstruktor
     *
     * @param message
     *            Text der Fehlermeldung.
     * @param exception
     *            Aufgetretene Ausnahme.
     */
    public ZippingException(String message, Exception exception) {
        super(message, exception);
    }

}
