package de.duehl.basics.io.lock;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

/**
 * Dieses Interface dient zur Abstraktion von konkreten Locks.
 *
 * @version 1.01     2017-03-27
 * @author Christian Dühl
 */

public interface Lock {

    /**
     * Versucht einen Lock auf die Datei zu erhalten.
     *
     * @return Erfolg
     */
    boolean lock();

    /**
     * Versucht den vorhandenen Lock wieder zu lösen.
     *
     * @return Erfolg.
     */
    boolean unlock();

    /** Getter für die Datei, die gelockt wird oder die zum Lock benutzt wird. */
    String getFilename();

}
