package de.duehl.basics.io.textfile;

/*
 * Copyright 2019 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import de.duehl.basics.io.Charset;

/**
 * Diese Klasse liest eine Liste mit den Texten aus den Zeilen einer normalen Textdatei ein.
 *
 * Die Zeilen werden getrimmt. Dabei werden leere Zeilen und solche, die mit dem Kommentarzeichen
 * (ggf., nach Leerraum) überlesen. Kommt in einer Datenzeile weiter hinten das Kommentarzeichen
 * vor, so wird ab dort abgeschnitten und getrimmt.
 *
 * @version 1.01     2019-03-21
 * @author Christian Dühl
 */

public class StringsFromNormalTextFileReader extends StringsFromTextFileReader {

    /**
     * Konstruktor.
     *
     * @param filename
     *            Name der einzulesenden Datei.
     * @param charset
     *            Kodierung der einzulesenden Datei.
     * @param commentChar
     *            Das Kommentarzeichen.
     */
    public StringsFromNormalTextFileReader(String filename, Charset charset, String commentChar) {
        super(new FullNormalTextFileReader(filename, charset), commentChar);
    }

}
