package de.duehl.basics.logging.reader;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.util.ArrayList;
import java.util.List;

import de.duehl.basics.io.FineFileReader;
import de.duehl.basics.io.Reader;
import de.duehl.basics.logging.LogEntry;

/**
 * Diese Klasse liest eine Log-Datei ein und erstellt eine Liste von LogLineElementen daraus.
 *
 * @version 1.01     2017-03-31
 * @author Christian Dühl
 */

public class LogFileReader {

    private final String logFileName;

    public LogFileReader(String logFileName) {
        this.logFileName = logFileName;
    }

    public List<LogEntry> read() {
        List<LogEntry> entries = new ArrayList<>();

        Reader reader = new FineFileReader(logFileName);
        String line;
        while (null != (line = reader.readNextLine())) {
            if (!line.isEmpty()) {
                entries.add(new LogEntry(line));
            }
        }

        return entries;
    }

}
