package de.duehl.basics.proccess;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.util.List;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.debug.DebugHelper;
import de.duehl.basics.io.FileHelper;

/**
 * Diese Klasse erzeugt eine Batchdatei und lässt diese laufen.
 *
 * @version 1.01     2017-04-21
 * @author Christian Dühl
 */

public class ExternalBatch {

    private static final String NAME_PRE = "externalBatch";
    private static final boolean DEBUG = false;

    /** Name der Batchdatei. */
    private final String batchFile;

    /**
     * Konstruktor.
     *
     * @param batchLines
     *            Zeilen der Batchdatei.
     */
    public ExternalBatch(String ... batchLines) {
        this(CollectionsHelper.stringArrayToList(batchLines));
    }

    /**
     * Konstruktor.
     *
     * @param batchLines
     *            Zeilen der Batchdatei.
     */
    public ExternalBatch(List<String> batchLines) {
        batchFile = FileHelper.createTempFile(NAME_PRE, ".bat").getPath();
        say("batchfile = " + batchFile);
        FileHelper.writeLinesToFile(batchLines, batchFile);
    }

    /**
     * Erzeugt und startet den Prozess mit der erzeugten Batch-Datei, wartet dann auf dessen
     * Beendigung und wertet am Ende die nach System.err geschriebenen Fehler aus.
     */
    public void createRunWaitAndHandleErrors() {
        ExternalProcess externalProcess = new ExternalProcess(batchFile);
        externalProcess.runWaitAndHandleErrors();
        FileHelper.deleteFileIfExistent(batchFile);
    }

    private void say(String message) {
        if (DEBUG) {
            DebugHelper.sayWithClassAndMethodAndTime(message);
        }
    }

}
