package de.duehl.basics.serializable;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.io.FileInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;

/**
 * Diese Klasse kann ein gespeichertes Javaobjekt wieder aus der Datei einlesen.
 *
 * @version 1.01     2016-12-09
 * @author Christian Dühl
 */

public class LoadSerializableObject {

    /** Name der Datei mit dem gespeichertem Javaobjekt. */
    private String filename;

    /**
     * Konstruktor.
     *
     * @param filename
     *            Name der Datei mit dem gespeichertem Javaobjekt.
     */
    public LoadSerializableObject(String filename) {
        this.filename = filename;
    }

    /** Lädt das gespeicherte Objekt. */
    public Serializable load() {
        InputStream fis = null;
        ObjectInputStream ois = null;
        Serializable result = null;
        try {
            fis = new FileInputStream(filename);
            ois = new ObjectInputStream(fis);
            result = (Serializable) ois.readObject();
        }
        catch (Exception e) {
            throw new RuntimeException("Fehler beim Laden eines persistenten Objektes.", e);
        }
        finally {
            try {
                if (null != ois) {
                    ois.close();
                }
                if (null != fis) {
                    fis.close();
                }
            }
            catch (Exception e) {
                // keine weitere Behandlung nötig, der Fehler wurde schon ausgegeben.
            }
        }

        return result;
    }

}
