package de.duehl.basics.test;

import java.util.Arrays;
import java.util.List;

import de.duehl.basics.io.FileHelper;

/**
 * Diese Klasse sucht den Code einer Testklasse auf der Festplatte (also nicht aus dem Jar).
 *
 * @version 1.01     2019-05-09
 * @author Christian Dühl
 */

public class FindJavaTestFileOnLocalHardDrive {

    private final TestHelper helper;

    public FindJavaTestFileOnLocalHardDrive(Class<?> clazz, int levelsAboveProjectDirectory,
            String... subDirectoriesFromProjectBaseToTestfiles) {
        this(clazz, levelsAboveProjectDirectory,
                Arrays.asList(subDirectoriesFromProjectBaseToTestfiles));
    }

    public FindJavaTestFileOnLocalHardDrive(Class<?> clazz, int levelsAboveProjectDirectory,
            List<String> subDirectoriesFromProjectBaseToTestfiles) {
        helper = new TestHelper(clazz, levelsAboveProjectDirectory,
                subDirectoriesFromProjectBaseToTestfiles);
    }

    /**
     * Sucht die ohne Pfad angegebene Java-Datei (etwa "AcronymFinderTest.java") im gewünschten
     * Test-Verzeichnis im Dateisystem.
     */
    public String findJavaTestFile(String testFilename) {
        String filename = helper.getTestFile(testFilename);
        checkIfTestFileExists(filename);
        return filename;
    }

    private void checkIfTestFileExists(String filename) {
        if (!FileHelper.isFile(filename)) {
            throw new RuntimeException("Die Datei " + filename + " existiert nicht.");
        }
    }

}
