package de.duehl.basics.text;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.util.Comparator;

/**
 * Diese Klasse vergleicht zwei Strings absteigend nach ihrer Länge.
 *
 * @version 1.01     2016-07-07
 * @author Christian Dühl
 */

public class DescandingStringLengthComparator implements Comparator<String> {

    @Override
    public int compare(String o1, String o2) {
        return o2.length() - o1.length();
    }

}
