package de.duehl.basics.text.html.generation;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

public class HtmlHeader {

    private final HtmlHeaderType type;
    private final String text;
    private final String id;

    public HtmlHeader(HtmlHeaderType type, String text, String id) {
        this.type = type;
        this.text = text;
        this.id = id;
    }

    public HtmlHeaderType getType() {
        return type;
    }

    public String getText() {
        return text;
    }

    public String getId() {
        return id;
    }

    public String getContentIndentation() {
        return type.getContentIndentation();
    }

    @Override
    public String toString() {
        return "HtmlHeader [type=" + type + ", text=" + text + ", id=" + id + "]";
    }

}
