package de.duehl.basics.text.html.generation.tools;

/*
 * Copyright 2024 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

/**
 * Diese Klasse stellt Methoden bereit, um Metainformationen zum UT(-Zeichensatz auszutauschen.
 *
 * @version 1.01     2024-07-10
 * @author Christian Dühl
 */

public class Utf8MetaExchanger {

    public static final String UTF8_META_LONG =
            "<meta http-equiv=\"content-Type\" content=\"text/html; charset=utf-8\">";
    public static final String UTF8_META_SHORT =
            "<meta charset=\"utf-8\">";

    /** Tauscht die lange durch die kurze Form aus. */
    public static String replaceLongToShort(String html) {
        return html.replace(UTF8_META_LONG, UTF8_META_SHORT);
    }

    /** Tauscht die kurze durch die lange Form aus. */
    public static String replaceShortToLong(String html) {
        return html.replace(UTF8_META_SHORT, UTF8_META_LONG);
    }

}
