package de.duehl.basics.text.xml;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

/**
 * Diese Klasse stellt einen benannten Parameter aus einem Tag eines XML-Dokuments dar.    </br><br>
 *
 * In <foo param="1" blubb="2"> .... </foo> wären das die beiden Parameter "param" und
 * "blubb" mit den Werten 1 bzw. 2.
 *
 * @version 1.01     2017-05-18
 * @author Christian Dühl
 */

public class NamedXmlParameter {

    /** Name des Parameters in der Form 'name="content"'. */
    private final String name;

    /** Inhalt des Parameters in der Form 'name="content"'. */
    private final String content;

    /**
     * Konstruktor.
     *
     * @param name
     *            Name des Parameters in der Form 'name="content"'.
     * @param content
     *            Inhalt des Parameters in der Form 'name="content"'.
     */
    public NamedXmlParameter(String name, String content) {
        this.name = name;
        this.content = content;
    }

    /**
     * Konstruktor.
     *
     * @param name
     *            Name des Parameters in der Form 'name="content"'.
     * @param content
     *            Inhalt des Parameters in der Form 'name="content"'.
     */
    public NamedXmlParameter(String name, int content) {
        this.name = name;
        this.content = Integer.toString(content);
    }

    /**
     * Konstruktor.
     *
     * @param name
     *            Name des Parameters in der Form 'name="content"'.
     * @param content
     *            Inhalt des Parameters in der Form 'name="content"'.
     */
    public NamedXmlParameter(String name, boolean content) {
        this.name = name;
        this.content = Boolean.toString(content);
    }

    /** Getter für den Namen des Parameters in der Form 'name="content"'. */
    public String getName() {
        return name;
    }

    /** Getter für den Inhalt des Parameters in der Form 'name="content"'. */
    public String getContent() {
        return content;
    }

    /** Stringrepräsentation für XML. */
    @Override
    public String toString() {
        return name + "=\"" + content + "\"";
    }

}
