package de.duehl.basics.text.xml.own;

/*
 * Copyright 2021 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

/**
 * Dieses Interface steht für ein Objekt, das aus einer eingelesenen Zeile ein wirkliches
 * Daten-Objekt erzeugen und dieses speichern kann.
 *
 * Sie sollte nicht für XML-Dateien aus anderen Quellen benutzt werden!
 *
 * @version 1.01     2021-10-21
 * @author Christian Dühl
 */

public interface SingleElementFromLineCreator {

    /**
     * Aus der übergebenen, eingelesenen Zeile wird ein wirkliches Daten-Objekt erzeugt und in
     * einer Collection gespeichert.
     *
     * @param line
     *            Eingelesene Zeile mit den Daten des Objektes.
     */
    void createAndStoreElementFromLine(String line);

}
