package de.duehl.basics.caller;

/*
 * Copyright 2022 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import static org.junit.Assert.*;

import java.util.List;

import org.junit.Test;

public class CallerDeterminerTest {

    @Test
    public void getStacktraceElementsNotNull() {
        List<NiceStackTraceElement> elements = CallerDeterminer.getStacktraceElements();
        //CollectionsHelper.printListNice(elements);
        assertNotNull(elements);
    }

    @Test
    public void determineCallingClassName() {
        String actual = callDetermineCallingClassNameForToHaveACaller();
        String expected = this.getClass().getName();
        assertEquals(expected, actual);
    }

    private String callDetermineCallingClassNameForToHaveACaller() {
        return CallerDeterminer.determineCallingClassName();
    }

    @Test
    public void determineCallingClass() {
        Class<?> actual = callClassForToHaveACaller();
        Class<?> expected = this.getClass();
        assertEquals(expected, actual);
    }

    private Class<?> callClassForToHaveACaller() {
        return CallerDeterminer.determineCallingClass();
    }

    @Test
    public void determineCallingMethodName() {
        String actual = callDetermineCallingMethodNameForToHaveACaller();
        String expected = "determineCallingMethodName";
        assertEquals(expected, actual);
    }

    private String callDetermineCallingMethodNameForToHaveACaller() {
        return CallerDeterminer.determineCallingMethodName();
    }

}
