package de.duehl.basics.io;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import static org.junit.Assert.*;

import org.junit.Test;

public class MD5Test {

    @Test
    public void buildMd5Number1() {
        String fileName = "u:/impressumProjekt/testsites/hupHtmlContent.txt";
        String value = MD5.generateMd5FromFile(fileName);
        assertEquals("c9c6b2d7d6e0cbd51fb83360f4c0a70d", value);
    }

    @Test
    public void buildMd5Number2() {
        String input = "abcd";
        String value = MD5.generateMd5(input, Charset.UTF_8);
        assertEquals("e2fc714c4727ee9395f324cd2e7f331f", value);
    }

    @Test
    public void buildMd5Number3() {
        String input = "abcd";
        String value = MD5.generateMd5(input, Charset.UTF_16LE);
        assertEquals("e4a5fc25f9bbe59ec5606fb8fc093c75", value);
    }

//    @Test
//    public void buildMd5Number3() {
//        String input = "abcd";
//        String value1 = MD5.generateMd5(input);
//        String value2 = MD5.md5Java(input);
//        assertEquals(value1, value2);
//    }

}
