package de.duehl.basics.io.done;

/*
 * Copyright 2019 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.io.File;

import de.duehl.basics.test.TestHelper;

import static org.junit.Assert.*;
import org.junit.Test;

public class DoneListTest {

    private final String path;

    public DoneListTest() {
        TestHelper testHelper = TestHelper.createForBasics(getClass(), 7);
        path =  testHelper.getTestDataPath() + File.separator + "done" + File.separator;
    }


    /* -------------------------- TESTS -------------------------- */


    @Test
    public void newListIsEmpty() {
        DoneList list = new DoneList();
        assertTrue(list.isEmpty());
    }

    @Test
    public void newListAllDoneMarkersExistBecauseListIsEmpty() {
        DoneList list = new DoneList();
        assertTrue(list.existAllDoneMarkers());
    }

    @Test
    public void fillDoneIntoNewListAndIsNotEmpty() {
        DoneList list = new DoneList();

        String fileToCreateDoneFileFor = "c:\\foo\\bar\\baz.txt";
        Done done = new Done(fileToCreateDoneFileFor);
        list.add(done);

        assertFalse(list.isEmpty());
    }

    @Test
    public void fillDoneViaFileIntoNewListAndIsNotEmpty() {
        DoneList list = new DoneList();

        String fileToCreateDoneFileFor = "c:\\foo\\bar\\baz.txt";
        list.createDoneAndAdd(fileToCreateDoneFileFor);

        assertFalse(list.isEmpty());
    }

    @Test
    public void fillDoneIntoNewListAndNotAllDoneMarkersExist() {
        DoneList list = new DoneList();

        String fileToCreateDoneFileFor = "c:\\foo\\bar\\baz.txt";
        Done done = new Done(fileToCreateDoneFileFor);
        list.add(done);

        assertFalse(list.existAllDoneMarkers());
    }

    @Test
    public void clearedListIsEmpty() {
        DoneList list = new DoneList();

        String fileToCreateDoneFileFor = "c:\\foo\\bar\\baz.txt";
        Done done = new Done(fileToCreateDoneFileFor);
        list.add(done);

        list.clear();

        assertTrue(list.isEmpty());
    }

    @Test
    public void removeAndListIsEmpty() {
        DoneList list = new DoneList();

        String fileToCreateDoneFileFor = "c:\\foo\\bar\\baz.txt";
        Done done = new Done(fileToCreateDoneFileFor);
        list.add(done);

        list.remove(done);

        assertTrue(list.isEmpty());
    }

    @Test
    public void removeViaIndexAndListIsEmpty() {
        DoneList list = new DoneList();

        String fileToCreateDoneFileFor = "c:\\foo\\bar\\baz.txt";
        Done done = new Done(fileToCreateDoneFileFor);
        list.add(done);

        list.remove(0);

        assertTrue(list.isEmpty());
    }

    @Test
    public void fillDoneIntoNewListCreateMarkerFileAndAllDoneMarkersExist() {
        DoneList list = new DoneList();

        String fileToCreateDoneFileFor = path + "baz.txt";
        Done done = new Done(fileToCreateDoneFileFor);
        list.add(done);

        done.createDoneFile();

        assertTrue(list.existAllDoneMarkers());

        list.deleteAllDoneFiles(); // aufräumen
    }

    @Test
    public void iterateAboutList() {
        DoneList list = new DoneList();

        String fileToCreateDoneFileFor1 = path + "foo.txt";
        String fileToCreateDoneFileFor2 = path + "bar.txt";
        String fileToCreateDoneFileFor3 = path + "baz.txt";

        Done done1 = new Done(fileToCreateDoneFileFor1);
        list.add(done1);
        Done done2 = new Done(fileToCreateDoneFileFor2);
        list.add(done2);
        Done done3 = new Done(fileToCreateDoneFileFor3);
        list.add(done3);

        for (Done done : list) {
            String fileToCreateDoneFileFor = done.getFileToCreateDoneFileFor();
            assertTrue(fileToCreateDoneFileFor.equals(fileToCreateDoneFileFor1)
                    || fileToCreateDoneFileFor.equals(fileToCreateDoneFileFor2)
                    || fileToCreateDoneFileFor.equals(fileToCreateDoneFileFor3)
                    );
        }
    }

    @Test
    public void size() {
        DoneList list = new DoneList();

        String fileToCreateDoneFileFor1 = path + "foo.txt";
        String fileToCreateDoneFileFor2 = path + "bar.txt";
        String fileToCreateDoneFileFor3 = path + "baz.txt";

        Done done1 = new Done(fileToCreateDoneFileFor1);
        list.add(done1);
        Done done2 = new Done(fileToCreateDoneFileFor2);
        list.add(done2);
        Done done3 = new Done(fileToCreateDoneFileFor3);
        list.add(done3);

        assertEquals(3, list.size());
    }

}
