package de.duehl.basics.io.textfile;

/*
 * Copyright 2019 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import static org.junit.Assert.*;

import java.util.List;

import org.junit.Test;

import de.duehl.basics.io.Charset;

public class StringsFromTextFileInJarReaderTest {

    @Test
    public void read() {
        Class<?> clazz = this.getClass();
        StringsFromTextFileReader reader = new StringsFromTextFileInJarReader("test_datei.txt",
                Charset.UTF_8, clazz, "#");
        reader.beQuiet();
        List<String> list = reader.read();
        assertEquals(4, list.size());
        assertEquals("eins", list.get(0));
        assertEquals("zwei", list.get(1));
        assertEquals("drei", list.get(2));
        assertEquals("GroßBuchstAben?", list.get(3));
    }

}
