package de.duehl.basics.io.textfile.dictionary.io;

/*
 * Copyright 2024 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import static org.junit.Assert.assertEquals;

import java.io.File;
import java.util.List;

import org.junit.Test;

import de.duehl.basics.io.Charset;
import de.duehl.basics.io.FileHelper;
import de.duehl.basics.io.textfile.dictionary.Dictionary;
import de.duehl.basics.io.textfile.dictionary.DictionaryEntry;
import de.duehl.basics.io.textfile.dictionary.io.reader.DictionaryFromNormalTextFileReader;
import de.duehl.basics.io.textfile.dictionary.io.reader.DictionaryFromTextFileReader;
import de.duehl.basics.test.TestHelper;

public class DictionaryFromNormalTextFileReaderTest {

    private final String path;

    public DictionaryFromNormalTextFileReaderTest() {
        TestHelper testHelper = TestHelper.createForBasics(getClass(), 9);
        path =  testHelper.getTestDataPath() + File.separator;
    }


    /* -------------------------- TESTS -------------------------- */


    @Test
    public void read() {
        DictionaryFromTextFileReader reader = new DictionaryFromNormalTextFileReader(
                FileHelper.concatPathes(path, "DictionaryTestFile.txt"), Charset.UTF_8, "#");
        reader.beQuiet();
        reader.read();
        Dictionary dictionary = reader.getDictionary();

        assertEquals(3, dictionary.size());

        DictionaryEntry entry1 = dictionary.get(0);
        DictionaryEntry entry2 = dictionary.get(1);
        DictionaryEntry entry3 = dictionary.get(2);

        assertEquals(5, entry1.size());
        assertEquals(3, entry2.size());
        assertEquals(2, entry3.size());

        assertEquals("Englisches Wort", entry1.getMainWord());
        List<String> alternatives1 = entry1.getAlternatives();
        assertEquals("Deutsches Wort 1", alternatives1.get(0));
        assertEquals("Deutsches Wort 2", alternatives1.get(1));
        assertEquals("Deutsches Wort 3", alternatives1.get(2));
        assertEquals("Deutsches Wort 4", alternatives1.get(3));

        assertEquals("honey", entry2.getMainWord());
        List<String> alternatives2 = entry2.getAlternatives();
        assertEquals("Honig", alternatives2.get(0));
        assertEquals("Liebling", alternatives2.get(1));

        assertEquals("bee", entry3.getMainWord());
        List<String> alternatives3 = entry3.getAlternatives();
        assertEquals("Biene", alternatives3.get(0));
    }

}
