package de.duehl.basics.io.textfile.dictionary.join;

/*
 * Copyright 2024 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import org.junit.Test;

import de.duehl.basics.io.textfile.dictionary.Dictionary;
import de.duehl.basics.io.textfile.dictionary.DictionaryEntry;

import static org.junit.Assert.*;

public class SimpleDictionaryJoinerTest {

    @Test
    public void join1() {
        DictionaryEntry fooEntry = new DictionaryEntry("foo");
        fooEntry.addAlternative("bar");
        fooEntry.addAlternative("baz");

        Dictionary dictionary1 = new Dictionary();
        dictionary1.addDictionaryEntry(fooEntry);

        DictionaryEntry apfelEntry = new DictionaryEntry("Apfel");
        apfelEntry.addAlternative("Boskop");
        apfelEntry.addAlternative("Elstar");

        Dictionary dictionary2 = new Dictionary();
        dictionary2.addDictionaryEntry(apfelEntry);

        assertEquals(1, dictionary1.size());
        assertEquals(1, dictionary2.size());

        Dictionary dictionary = SimpleDictionaryJoiner.join(dictionary1, dictionary2);
        assertEquals(2, dictionary.size());

        assertTrue(dictionary.containsEntryWithMainWord("foo"));
        assertTrue(dictionary.containsEntryWithMainWord("Apfel"));

        DictionaryEntry actualFooEntry = dictionary.getEntryWithMainWord("foo");
        assertEquals("bar", actualFooEntry.getAlternatives().get(0));
        assertEquals("baz", actualFooEntry.getAlternatives().get(1));

        DictionaryEntry actualApfelEntry = dictionary.getEntryWithMainWord("Apfel");
        assertEquals("Boskop", actualApfelEntry.getAlternatives().get(0));
        assertEquals("Elstar", actualApfelEntry.getAlternatives().get(1));
    }

    @Test
    public void joinComplexCase() { // Hier sieht man, warum der DictionaryJoiner besser ist.
        DictionaryEntry fooEntry1 = new DictionaryEntry("foo");
        fooEntry1.addAlternative("bar");

        DictionaryEntry apfelEntry1 = new DictionaryEntry("Apfel");
        apfelEntry1.addAlternative("Boskop");
        apfelEntry1.addAlternative("Elstar");

        DictionaryEntry tierEntry = new DictionaryEntry("Tier");
        tierEntry.addAlternative("Katze");
        tierEntry.addAlternative("Hund");
        tierEntry.addAlternative("Hase");

        Dictionary dictionary1 = new Dictionary();
        dictionary1.addDictionaryEntry(fooEntry1);
        dictionary1.addDictionaryEntry(apfelEntry1);
        dictionary1.addDictionaryEntry(tierEntry);


        DictionaryEntry fooEntry2 = new DictionaryEntry("foo");
        fooEntry2.addAlternative("bar");
        fooEntry2.addAlternative("baz");

        DictionaryEntry apfelEntry2 = new DictionaryEntry("Apfel");
        apfelEntry2.addAlternative("Elstar");

        DictionaryEntry baumEntry = new DictionaryEntry("Baum");
        baumEntry.addAlternative("Eiche");
        baumEntry.addAlternative("Buche");
        baumEntry.addAlternative("Ahorn");
        baumEntry.addAlternative("Erle");

        Dictionary dictionary2 = new Dictionary();
        dictionary2.addDictionaryEntry(fooEntry2);
        dictionary2.addDictionaryEntry(apfelEntry2);
        dictionary2.addDictionaryEntry(baumEntry);


        assertEquals(3, dictionary1.size());
        assertEquals(3, dictionary2.size());


        Dictionary dictionary = SimpleDictionaryJoiner.join(dictionary1, dictionary2);

        assertEquals(6, dictionary.size());

        assertTrue(dictionary.containsEntryWithMainWord("foo"));
        assertTrue(dictionary.containsEntryWithMainWord("Apfel"));
        assertTrue(dictionary.containsEntryWithMainWord("Tier"));
        assertTrue(dictionary.containsEntryWithMainWord("Baum"));

        /*
         * Da hier die Hauptworte teilweise mehrfach enthalten sind, muss ich über den Index gehen:
         */

        DictionaryEntry actualFooEntry1 = dictionary.get(0);
        assertEquals(2, actualFooEntry1.size());
        assertEquals("foo", actualFooEntry1.getMainWord());
        assertEquals("bar", actualFooEntry1.getAlternatives().get(0));

        DictionaryEntry actualApfelEntry1 = dictionary.get(1);
        assertEquals(3, actualApfelEntry1.size());
        assertEquals("Apfel", actualApfelEntry1.getMainWord());
        assertEquals("Boskop", actualApfelEntry1.getAlternatives().get(0));
        assertEquals("Elstar", actualApfelEntry1.getAlternatives().get(1));

        DictionaryEntry actualTierEntry = dictionary.get(2);
        assertEquals(4, actualTierEntry.size());
        assertEquals("Tier", actualTierEntry.getMainWord());
        assertEquals("Katze", actualTierEntry.getAlternatives().get(0));
        assertEquals("Hund", actualTierEntry.getAlternatives().get(1));
        assertEquals("Hase", actualTierEntry.getAlternatives().get(2));

        DictionaryEntry actualFooEntry2 = dictionary.get(3);
        assertEquals(3, actualFooEntry2.size());
        assertEquals("foo", actualFooEntry2.getMainWord());
        assertEquals("bar", actualFooEntry2.getAlternatives().get(0));
        assertEquals("baz", actualFooEntry2.getAlternatives().get(1));

        DictionaryEntry actualApfelEntry2 = dictionary.get(4);
        assertEquals(2, actualApfelEntry2.size());
        assertEquals("Apfel", actualApfelEntry2.getMainWord());
        assertEquals("Elstar", actualApfelEntry2.getAlternatives().get(0));

        DictionaryEntry actualBaumEntry = dictionary.get(5);
        assertEquals(5, actualBaumEntry.size());
        assertEquals("Baum", actualBaumEntry.getMainWord());
        assertEquals("Eiche", actualBaumEntry.getAlternatives().get(0));
        assertEquals("Buche", actualBaumEntry.getAlternatives().get(1));
        assertEquals("Ahorn", actualBaumEntry.getAlternatives().get(2));
        assertEquals("Erle", actualBaumEntry.getAlternatives().get(3));
    }

}
