package de.duehl.basics.logic;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import static org.junit.Assert.*;

import java.util.HashMap;
import java.util.Map;

import org.junit.Test;

public class SimpleTemplatingTest {

    @Test
    public void tzest1() {
        Map<String, String> translations = new HashMap<>();
        translations.put("DATE", "09.12.2016");
//        translations.put("DAY", "09");
//        translations.put("MONTH", "12");
//        translations.put("YEAR", "2016");
        translations.put("NAME", "Christian Dühl");

        String input = "Am heutigen Tage, dem @@DATE@@, hat @@NAME@@ diesen Test geschrieben.";
        String expected = "Am heutigen Tage, dem 09.12.2016, hat Christian Dühl diesen Test geschrieben.";
        SimpleTemplating templating = new SimpleTemplating();
        String actual = templating.templateString(input, translations);
        assertEquals(expected, actual);
    }

}
