package de.duehl.basics.retry.retryable;

import de.duehl.basics.retry.Retryable;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

public class TestRetryable implements Retryable {

    private final int numberOfTriesFailing;

    private int tryCount = 0;

    public TestRetryable(int numberOfTriesFailing) {
        this.numberOfTriesFailing = numberOfTriesFailing;
    }

    @Override
    public void tryIt() {
        ++tryCount;
        if (tryCount <= numberOfTriesFailing) {
            throw new RuntimeException("Misserfolg Nummer " + tryCount);
        }
    }

    public int getTryCount() {
        return tryCount;
    }

}
