package de.duehl.basics.start;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.util.List;

import de.duehl.basics.io.FileHelper;
import de.duehl.basics.logic.CommandLineArguments;
import de.duehl.basics.text.Text;

public class StripCommentLinesFromFile {

    public static void main(String[] args) {
        main(new CommandLineArguments(args));
        //main(new CommandLineArguments(new String[] {
        //        "e:/tv/20151016_serien_stand_wohnzimmerliste.txt",
        //        "e:/tv/20151016_serien_stand_wohnzimmerliste_out.txt"}));
    }

    private static void main(CommandLineArguments arguments) {
        if (arguments.numberOfParameterIs(2) && arguments.numberOfFlagOptionsIs(0)) {
            stripComentsLinesFromFile(arguments.getParameter(0),
                    arguments.getParameter(1));
        }
        else {
            System.out.println("Es werden genau zwei Parameter erwartet:\n"
                    + "    1) Name der einzulesenden Datei\n"
                    + "    2) Name der zu erzeugenden Datei\n");
        }
    }

    private static void stripComentsLinesFromFile(final String filenameFrom,
            final String fileNameTo) {
        List<String> lines = FileHelper.readFileToList(filenameFrom);
        List<String> stripped = Text.stripCommentsFromLines(lines);
        FileHelper.writeLinesToFile(stripped, fileNameTo);
    }

}
