package de.duehl.html.download.proxy;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.util.List;

import de.duehl.basics.debug.Assure;

/**
 * Diese Klasse verwaltet eine rotierende Liste von Proxies.
 *
 * @version 1.01     2017-04-27
 * @author Christian Dühl
 */

public class RotatingProxies {

    /** Liste der vorgehaltenen Proxies. */
    private final List<Proxy> proxies;

    /** Index des aktuell verwendeten Proxy. */
    private int proxyIndex;

    /** Konstruktor. */
    public RotatingProxies(List<Proxy> proxies) {
        Assure.notEmpty(proxies);
        this.proxies = proxies;
        proxyIndex = 0;
    }

    /** Gibt den aktuell verwendeten Proxy zurück. */
    public Proxy getProxy() {
        return proxies.get(proxyIndex);
    }

    /** Schaltet auf den nächsten Proxy weiter. */
    public void switchProxy() {
        ++proxyIndex;
        if (proxyIndex >= proxies.size()) {
            proxyIndex = 0;
        }
    }

    /** Gibt die Anzahl der in der Rotation verwendeten Proxies zurück. */
    public int getNumberOfProxies() {
        return proxies.size();
    }

    @Override
    public String toString() {
        return "RotatingProxies [proxies=" + proxies + ", proxyIndex=" + proxyIndex + "]";
    }

}
