package de.duehl.mp3.player.javazoom.data;

import de.duehl.mp3.player.javazoom.MoreAdvancedPlayer;

/*
 * 11/19/04     1.0 moved to LGPL.
 *-----------------------------------------------------------------------
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License as published
 *   by the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU Library General Public License for more details.
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *----------------------------------------------------------------------
 */

/**
 * Ein Event das ausgelöst wird, wenn ein Player eine bestimmte Abspiel-Aktion gestartet hat.
 *
 * Ursprüngliche Version von Stanton (http://wanto.f2o.org/).
 *
 * @version 1.01     2025-07-23
 * @author Christian Dühl
 */

public class MoreAdvancedPlaybackEvent {

    /** Die Event-ID die zum Ende eines abgespielten Musikstücks gehört. */
    public static final int STOPPED = 1;

    /** Die Event-ID die zum Anfang eines abgespielten Musikstücks gehört. */
    public static final int STARTED = 2;

    /** Der Player, der zum Event gehört. */
    private MoreAdvancedPlayer source;

    /** Die ID des Events. */
    private int id;

    /** Der Frame an dem das Event ausgelöst wurde. */
    private int frame;

    /**
     * Konstruktor.
     *
     * @param source
     *            Der Player, der zum Event gehört.
     * @param id
     *            Die ID des Events.
     * @param frame
     *            Der Frame an dem das Event ausgelöst wurde.
     */
    public MoreAdvancedPlaybackEvent(MoreAdvancedPlayer source, int id, int frame) {
        this.source = source;
        this.id = id;
        this.frame = frame;
    }

    /** Getter für den Player, der zum Event gehört. */
    public MoreAdvancedPlayer getSource() {
        return source;
    }

    /** Setter für den Player, der zum Event gehört. */
    public void setSource(MoreAdvancedPlayer source) {
        this.source = source;
    }

    /** Getter für die ID des Events. */
    public int getId() {
        return id;
    }

    /** Setter für die ID des Events. */
    public void setId(int id) {
        this.id = id;
    }

    /** Getter für den Frame an dem das Event ausgelöst wurde. */
    public int getFrame() {
        return frame;
    }

    /** Setter für den Frame an dem das Event ausgelöst wurde. */
    public void setFrame(int frame) {
        this.frame = frame;
    }

}
