package de.duehl.mp3.unused;

import java.util.ArrayList;
import java.util.List;

import de.duehl.mp3.player.MP3Player;

/**
 * Bislang ungetestet!
 *
 * @author David J. Barnes und Michael Kölling, überarbeitet von Christian Dühl
 * @version 31.07.2011, 12.10.2023
 *
 * Siehe auch: https://falconbyte.net/blog-java-mp3.php
 */

public class PlayList {

    private MP3Player player;
    private List<String> songs;

    public PlayList() {
        player = new MP3Player();
        songs = new ArrayList<>();
    }

    /** Füllt die List der Songs. */
    public void erstellePlaylist() {
        songs.add("audio/CnC - mechanical man.mp3");
        songs.add("audio/Deep Into The Code.mp3");
        songs.add("audio/Sign of Evil.mp3");
    }

    /** Spielt alle Songs der Liste kurz an. */
    @SuppressWarnings("unused")
    public void alleSongsPreview() {
        for (String song : songs) {
            //player.playFirstPart(song);
        }
    }

    /** Spielt einen Song gezielt nach dessen Index ab. */
    public void spieleSongNummer(int index) {
        String dateiname = songs.get(index);
        player.playMP3InOwnThread(dateiname);
    }

    /** Durchsucht die Dateinamen aller Songs und spielt den ersten gefundenen Song ab. */
    public void spieleSongName(String search) {
        String suchwort = search.toLowerCase();
        boolean gefunden = false;
        int found = -1;

        for (int i = 0; i < songs.size() && !gefunden; i++) {
            if (songs.get(i).toLowerCase().contains(suchwort)) {
                gefunden = true;
                found = i;
            }
        }

        if (gefunden) {
            spieleSongNummer(found);
        }
        else {
            System.out.println("Kein Song gefunden, der " + search + " beinhaltet.");
        }
    }

}