package de.duehl.swing.debug.data;

/*
 * Copyright 2025 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import de.duehl.basics.datetime.date.ImmutualDate;
import de.duehl.basics.datetime.time.ImmutualTime;

/**
 * Diese Klasse stellt eine Debugmeldung dar.
 *
 * @version 1.01     2025-07-29
 * @author Christian Dühl
 */

public class DebugMessage {

    /** Das Datum der Meldung. */
    private final ImmutualDate date;

    /** Der Zeitpunkt der Meldung. */
    private final ImmutualTime time;

    /** Die Kategorie der Meldung. */
    private final String category;

    /** Der Name der Klasse in der die Meldung erzeugt wurde. */
    private final String className;

    /** Der Name der Methode in der die Meldung erzeugt wurde. */
    private final String methodName;

    /** Die Zeilennummer in der die Meldung erzeugt wurde. */
    private final String lineNumber;

    /** Der Text der Meldung. */
    private final String message;

    /**
     * Konstruktor.
     *
     * @param date
     *            Das Datum der Meldung.
     * @param time
     *            Der Zeitpunkt der Meldung.
     * @param category
     *            Die Kategorie der Meldung.
     * @param className
     *            Der Name der Klasse in der die Meldung erzeugt wurde.
     * @param methodName
     *            Der Name der Methode in der die Meldung erzeugt wurde.
     * @param lineNumber
     *            Die Zeilennummer in der die Meldung erzeugt wurde.
     * @param message
     *            Der Text der Meldung.
     */
    public DebugMessage(ImmutualDate date, ImmutualTime time, String category, String className,
            String methodName, String lineNumber, String message) {
        this.date = date;
        this.time = time;
        this.category = category;
        this.className = className;
        this.methodName = methodName;
        this.lineNumber = lineNumber;
        this.message = message;
    }

    /** Getter für das Datum der Meldung. */
    public ImmutualDate getDate() {
        return date;
    }

    /** Getter für den Zeitpunkt der Meldung. */
    public ImmutualTime getTime() {
        return time;
    }

    /** Getter für die Kategorie der Meldung. */
    public String getCategory() {
        return category;
    }

    /** Getter für den Namen der Klasse in der die Meldung erzeugt wurde. */
    public String getClassName() {
        return className;
    }

    /** Getter für den Namen der Methode in der die Meldung erzeugt wurde. */
    public String getMethodName() {
        return methodName;
    }

    /** Getter für die Zeilennummer in der die Meldung erzeugt wurde. */
    public String getLineNumber() {
        return lineNumber;
    }

    /** Getter für den Text der Meldung. */
    public String getMessage() {
        return message;
    }

    @Override
    public String toString() {
        return "DebugMessage [date=" + date + ", time=" + time + ", category=" + category
                + ", className=" + className + ", methodName=" + methodName + ", lineNumber="
                + lineNumber + ", message=" + message + "]";
    }

}
