package de.duehl.swing.ui.buttons.creator;

/*
 * Copyright 2021 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.Component;

/**
 * Dieses Interface steht für eine Klasse, die einen Button erstellt. Konkreten Klassen, die dieses
 * Interface implementieren, kann man über den Konstruktor oder Setter Einstellungen mitgeben,
 * schließlich müssen sie alle die eine Methode vorhalten, um den Button letztlich zu erstellen.
 *
 * Es wird bewusst kein JButton, sondern eine Component zurückgegeben, da man auch Label und
 * anderes zu "Button-Zwecken" verwenden kann.
 *
 * @version 1.01     2021-05-07
 * @author Christian Dühl
 */

public interface ButtonCreator {

    /**
     * Erstellt einen Button mit der passenden Aufschrift und hinterlegt die Aktion für den Klick
     * auf den Button.
     *
     * @param text
     *            Beschriftung des Buttons.
     * @param buttonClickAction
     *            Aktion die bei einem Klick auf den Button ausgeführt wird.
     */
    Component createButton(String text, Runnable buttonClickAction);

}
