package de.duehl.swing.ui.buttons.painted;

/*
 * Copyright 2025 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.Color;

import de.duehl.swing.ui.geometry.PixelPoint;

/**
 * Diese Klasse stellt einen kleinen Schalter zum Bearbeiten von etwas dar.
 *
 * @version 1.01     2025-07-23
 * @author Christian Dühl
 */

final public class EditButton extends PaintedButton {

    private static final long serialVersionUID = 5863401016558473960L;

    /** Konstruktor. */
    public EditButton() {
        super();
    }

    /**
     * Farbwahl abhängig davon, ob die Maus über dem Button ist.
     *
     * Default: Schwarz normalerweise, wenn die Maus darüber kommt, Blau.
     */
    @Override
    protected void setSymbolColorInGraphics() {
        graphics2.setColor(Color.BLACK);
        if (isChangeColorOnMouseOver() && getModel().isRollover()) {
            graphics2.setColor(Color.BLUE);
        }
    }

    /** Zeichnet das Symbol in horizontaler und rechteckiger Anordnung. */
    @Override
    protected void paintHorizontalSymbolRectangle() {
        paintSymbol();
    }

    /** Zeichnet das Symbol in vertikaler und rechteckiger Anordnung. */
    @Override
    protected void paintVerticalSymbolRectangle() {
        paintSymbol();
    }

    /** Zeichnet das Symbol in horizontaler und quadratischer Anordnung. */
    @Override
    protected void paintHorizontalSymbolSquare() {
        paintSymbol();
    }

    /** Zeichnet das Symbol in vertikaler und quadratischer Anordnung. */
    @Override
    protected void paintVerticalSymbolSquare() {
        paintSymbol();
    }

    /** Zeichnet das kleine Stiftchen zum Bearbeiten. */
    private void paintSymbol() {
        int width = getWidth();
        int height = getHeight();

        if (isForceSquare()) {
            width = Math.min(width, height);
            height = width;
        }

        int delta = 5; //6

        int firstLeftPixel = (getWidth() - width)/2;
        int left = firstLeftPixel + delta;

        int lastRightPixel = firstLeftPixel + width - 1;
        int right = lastRightPixel - delta;

        int firstUpperPixel = (getHeight() - height)/2;
        int upper = firstUpperPixel + delta;

        int lastLowerPixel = firstUpperPixel + height - 1;
        int lower = lastLowerPixel - delta;

        paintLine(
                new PixelPoint(left + 1,   lower + 1),
                new PixelPoint(right + 1,  upper + 1)
                );
        paintLine(
                new PixelPoint(left,   lower),
                new PixelPoint(right,  upper)
                );
        //paintLine(
        //        new PixelPoint(left - 1,   lower - 1),
        //        new PixelPoint(right - 1,  upper - 1)
        //        );
    }

}
